﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoiceV2 {
namespace Model {

/**
 * <p>Contains the delivery stream Amazon Resource Name (ARN), and the ARN of the
 * Identity and Access Management (IAM) role associated with a Firehose event
 * destination.</p> <p>Event destinations, such as Firehose, are associated with
 * configuration sets, which enable you to publish message sending
 * events.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/KinesisFirehoseDestination">AWS
 * API Reference</a></p>
 */
class KinesisFirehoseDestination {
 public:
  AWS_PINPOINTSMSVOICEV2_API KinesisFirehoseDestination() = default;
  AWS_PINPOINTSMSVOICEV2_API KinesisFirehoseDestination(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINTSMSVOICEV2_API KinesisFirehoseDestination& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINTSMSVOICEV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of an Identity and Access Management role that is able to write event
   * data to an Amazon Data Firehose destination.</p>
   */
  inline const Aws::String& GetIamRoleArn() const { return m_iamRoleArn; }
  inline bool IamRoleArnHasBeenSet() const { return m_iamRoleArnHasBeenSet; }
  template <typename IamRoleArnT = Aws::String>
  void SetIamRoleArn(IamRoleArnT&& value) {
    m_iamRoleArnHasBeenSet = true;
    m_iamRoleArn = std::forward<IamRoleArnT>(value);
  }
  template <typename IamRoleArnT = Aws::String>
  KinesisFirehoseDestination& WithIamRoleArn(IamRoleArnT&& value) {
    SetIamRoleArn(std::forward<IamRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the delivery stream.</p>
   */
  inline const Aws::String& GetDeliveryStreamArn() const { return m_deliveryStreamArn; }
  inline bool DeliveryStreamArnHasBeenSet() const { return m_deliveryStreamArnHasBeenSet; }
  template <typename DeliveryStreamArnT = Aws::String>
  void SetDeliveryStreamArn(DeliveryStreamArnT&& value) {
    m_deliveryStreamArnHasBeenSet = true;
    m_deliveryStreamArn = std::forward<DeliveryStreamArnT>(value);
  }
  template <typename DeliveryStreamArnT = Aws::String>
  KinesisFirehoseDestination& WithDeliveryStreamArn(DeliveryStreamArnT&& value) {
    SetDeliveryStreamArn(std::forward<DeliveryStreamArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_iamRoleArn;
  bool m_iamRoleArnHasBeenSet = false;

  Aws::String m_deliveryStreamArn;
  bool m_deliveryStreamArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
