/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.musicbrainz.mmd2.EntityList;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.AllWriter;
import org.musicbrainz.search.servlet.mmd2.ArtistWriter;
import org.musicbrainz.search.servlet.mmd2.LabelWriter;
import org.musicbrainz.search.servlet.mmd2.RecordingWriter;
import org.musicbrainz.search.servlet.mmd2.ReleaseGroupWriter;
import org.musicbrainz.search.servlet.mmd2.ReleaseWriter;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;
import org.musicbrainz.search.servlet.mmd2.WorkWriter;

public class AllWriter
extends ResultsWriter {
    private int limit;
    private int offset;
    private Results artistResults;
    private Results releaseResults;
    private Results releaseGroupResults;
    private Results labelResults;
    private Results recordingResults;
    private Results workResults;

    public AllWriter(int offset, int limit, Results artistResults, Results releaseResults, Results releaseGroupResults, Results labelResults, Results recordingResults, Results workResults) {
        this.offset = offset;
        this.limit = limit;
        this.artistResults = artistResults;
        this.releaseResults = releaseResults;
        this.releaseGroupResults = releaseGroupResults;
        this.labelResults = labelResults;
        this.recordingResults = recordingResults;
        this.workResults = workResults;
    }

    public void write(Metadata metadata, Results results) throws IOException {
    }

    public Metadata write(Results results) throws IOException {
        List allResults = new ArrayList();
        ArrayList<Results> resultsList = new ArrayList<Results>();
        resultsList.add(this.artistResults);
        resultsList.add(this.releaseResults);
        resultsList.add(this.releaseGroupResults);
        resultsList.add(this.labelResults);
        resultsList.add(this.recordingResults);
        resultsList.add(this.workResults);
        Collections.sort(resultsList);
        Collections.reverse(resultsList);
        float bestMaxScore = ((Results)resultsList.get(0)).getMaxScore();
        for (Results next : resultsList) {
            next.setMaxScore(bestMaxScore);
            for (Result nextResult : next.results) {
                nextResult.setNormalizedScore(bestMaxScore);
                nextResult.setResourceType(next.getResourceType());
            }
            allResults.addAll(next.results);
        }
        Collections.sort(allResults);
        Collections.reverse(allResults);
        ObjectFactory of = new ObjectFactory();
        Metadata metadata = of.createMetadata();
        EntityList entityList = of.createEntityList();
        metadata.setEntityList(entityList);
        ArtistWriter artistWriter = new ArtistWriter();
        ReleaseWriter releaseWriter = new ReleaseWriter();
        ReleaseGroupWriter releaseGroupWriter = new ReleaseGroupWriter();
        LabelWriter labelWriter = new LabelWriter();
        RecordingWriter recordingWriter = new RecordingWriter();
        WorkWriter workWriter = new WorkWriter();
        if (allResults.size() > this.limit) {
            allResults = allResults.subList(0, this.limit);
        }
        for (Result result : allResults) {
            switch (1.$SwitchMap$org$musicbrainz$search$servlet$ResourceType[result.getResourceType().ordinal()]) {
                case 1: {
                    artistWriter.write(entityList.getArtistAndReleaseAndReleaseGroup(), result);
                    break;
                }
                case 2: {
                    labelWriter.write(entityList.getArtistAndReleaseAndReleaseGroup(), result);
                    break;
                }
                case 3: {
                    releaseWriter.write(entityList.getArtistAndReleaseAndReleaseGroup(), result);
                    break;
                }
                case 4: {
                    releaseGroupWriter.write(entityList.getArtistAndReleaseAndReleaseGroup(), result);
                    break;
                }
                case 5: {
                    recordingWriter.write(entityList.getArtistAndReleaseAndReleaseGroup(), result);
                    break;
                }
                case 6: {
                    workWriter.write(entityList.getArtistAndReleaseAndReleaseGroup(), result);
                }
            }
        }
        int totalHits = 0;
        int offset = ((Results)resultsList.get(0)).getOffset();
        for (Results next : resultsList) {
            totalHits += next.getTotalHits();
        }
        entityList.setCount(BigInteger.valueOf(totalHits));
        entityList.setOffset(BigInteger.valueOf(offset));
        return metadata;
    }
}

