/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.musicbrainz.search.LuceneVersion;
import org.musicbrainz.search.index.RecordingIndexField;
import org.musicbrainz.search.servlet.mmd1.ReleaseGroupType;
import org.musicbrainz.search.servlet.mmd1.V1TrackIndexField;

public class RecordingQueryParser
extends MultiFieldQueryParser {
    public RecordingQueryParser(String[] strings, Analyzer a) {
        super(LuceneVersion.LUCENE_VERSION, strings, a);
    }

    protected Query newTermQuery(Term term) {
        if (term.field().equals(RecordingIndexField.DURATION.getName()) || term.field().equals(RecordingIndexField.QUANTIZED_DURATION.getName()) || term.field().equals(RecordingIndexField.TRACKNUM.getName()) || term.field().equals(RecordingIndexField.NUM_TRACKS.getName()) || term.field().equals(RecordingIndexField.NUM_TRACKS_RELEASE.getName())) {
            try {
                int number = Integer.parseInt(term.text());
                BytesRefBuilder bytes = new BytesRefBuilder();
                NumericUtils.intToPrefixCoded((int)number, (int)0, (BytesRefBuilder)bytes);
                TermQuery tq = new TermQuery(new Term(term.field(), bytes.toBytesRef().utf8ToString()));
                return tq;
            }
            catch (NumberFormatException nfe) {
                return super.newTermQuery(term);
            }
        }
        if (term.field().equals(RecordingIndexField.RELEASE_TYPE.getName())) {
            try {
                int typeId = Integer.parseInt(term.text());
                if (typeId >= ReleaseGroupType.getMinSearchId() && typeId <= ReleaseGroupType.getMaxSearchId()) {
                    TermQuery tq = new TermQuery(new Term(term.field(), ReleaseGroupType.getBySearchId((int)typeId).getName()));
                    return tq;
                }
                return super.newTermQuery(term);
            }
            catch (NumberFormatException nfe) {
                return super.newTermQuery(term);
            }
        }
        return super.newTermQuery(term);
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        if (field != null) {
            if (field.equals(V1TrackIndexField.TRACK.getName())) {
                field = RecordingIndexField.RECORDING.getName();
            } else if (field.equals(V1TrackIndexField.TRACK_ID.getName())) {
                field = RecordingIndexField.RECORDING_ID.getName();
            }
        }
        return super.getFieldQuery(field, queryText, quoted);
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        if (field != null) {
            if (field.equals(V1TrackIndexField.TRACK.getName())) {
                field = RecordingIndexField.RECORDING.getName();
            } else if (field.equals(V1TrackIndexField.TRACK_ID.getName())) {
                field = RecordingIndexField.RECORDING_ID.getName();
            }
        }
        return super.getFieldQuery(field, queryText, slop);
    }

    public Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        if (field.equals(RecordingIndexField.DURATION.getName()) || field.equals(RecordingIndexField.QUANTIZED_DURATION.getName()) || field.equals(RecordingIndexField.TRACKNUM.getName()) || field.equals(RecordingIndexField.NUM_TRACKS.getName()) || field.equals(RecordingIndexField.NUM_TRACKS_RELEASE.getName())) {
            BytesRefBuilder bytes1 = new BytesRefBuilder();
            BytesRefBuilder bytes2 = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded((int)Integer.parseInt(part1), (int)0, (BytesRefBuilder)bytes1);
            NumericUtils.intToPrefixCoded((int)Integer.parseInt(part2), (int)0, (BytesRefBuilder)bytes2);
            part1 = bytes1.toBytesRef().utf8ToString();
            part2 = bytes2.toBytesRef().utf8ToString();
        }
        TermRangeQuery query = (TermRangeQuery)super.newRangeQuery(field, part1, part2, startInclusive, endInclusive);
        return query;
    }
}

