/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MetaIndexField;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.ResultsWriter;
import org.musicbrainz.search.servlet.SearchServer;
import org.musicbrainz.search.servlet.mmd1.Mmd1XmlWriter;

public abstract class AbstractSearchServer
implements SearchServer {
    protected String query;
    protected int offset;
    protected int limit;
    protected Analyzer analyzer;
    protected org.musicbrainz.search.servlet.mmd2.ResultsWriter resultsWriter;
    protected Mmd1XmlWriter mmd1Writer;
    protected List<String> defaultFields;
    protected SearcherManager searcherManager;
    protected Date serverLastUpdatedDate;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm zz", Locale.US);
    protected AtomicInteger searchCount = new AtomicInteger();

    protected AbstractSearchServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLastServerUpdatedDate() throws IOException {
        if (this.searcherManager == null) {
            return;
        }
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            Term term = new Term(MetaIndexField.META.getName(), "1");
            TermQuery query = new TermQuery(term);
            TopDocs hits = searcher.search((Query)query, 10);
            if (hits.scoreDocs.length == 0) {
                System.out.println("No matches in the index for the meta document.");
                return;
            }
            if (hits.scoreDocs.length > 1) {
                System.out.println("More than one meta document was found in the index.");
                return;
            }
            int docId = hits.scoreDocs[0].doc;
            MbDocument doc = new MbDocument(searcher.doc(docId));
            String lastUpdated = doc.get((IndexField)MetaIndexField.LAST_UPDATED);
            this.serverLastUpdatedDate = new Date(NumericUtils.prefixCodedToLong((BytesRef)new BytesRef((CharSequence)lastUpdated)));
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    public Date getServerLastUpdatedDate() {
        return this.serverLastUpdatedDate;
    }

    public void reloadIndex() throws CorruptIndexException, IOException {
        if (this.searcherManager != null) {
            this.searcherManager.maybeRefresh();
            this.setLastServerUpdatedDate();
            this.resultsWriter.setLastServerUpdatedDate(this.getServerLastUpdatedDate());
        }
    }

    public void close() throws IOException {
        if (this.searcherManager == null) {
            return;
        }
        this.searcherManager.close();
    }

    public org.musicbrainz.search.servlet.mmd2.ResultsWriter getMmd2Writer() {
        return this.resultsWriter;
    }

    public Mmd1XmlWriter getMmd1Writer() {
        return this.mmd1Writer;
    }

    public List<String> getSearchFields() {
        return this.defaultFields;
    }

    public ResultsWriter getWriter(String version) {
        if ("1".equals(version)) {
            return this.getMmd1Writer();
        }
        return this.getMmd2Writer();
    }

    public Results search(String query, int offset, int limit) throws IOException, ParseException {
        return this.search(this.parseQuery(query), offset, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results search(Query query, int offset, int limit) throws IOException, ParseException, TimeLimitingCollector.TimeExceededException {
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)(offset + limit), (boolean)true);
            TimeLimitingCollector tCollector = new TimeLimitingCollector((Collector)collector, TimeLimitingCollector.getGlobalCounter(), 1000L);
            searcher.search(query, (Collector)tCollector);
            this.searchCount.incrementAndGet();
            TopDocs topDocs = collector.topDocs();
            if (topDocs == null) {
                Results results = new Results();
                return results;
            }
            Results results = this.processResults(searcher, topDocs, offset);
            return results;
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    protected Query parseQuery(String query) throws ParseException {
        QueryParser parser = this.getParser();
        return parser.parse(query);
    }

    public String getCount() {
        return this.searchCount.toString();
    }

    public abstract QueryParser getParser();

    protected Results processResults(IndexSearcher searcher, TopDocs topDocs, int offset) throws IOException {
        Results results = new Results();
        results.setOffset(offset);
        results.setTotalHits(topDocs.totalHits);
        ScoreDoc[] docs = topDocs.scoreDocs;
        results.setMaxScore(topDocs.getMaxScore());
        for (int i = offset; i < docs.length; ++i) {
            Result result = new Result();
            result.setScore(docs[i].score);
            result.setDoc(new MbDocument(searcher.doc(docs[i].doc)));
            results.results.add(result);
        }
        return results;
    }

    public String explain(String userQuery, int offset, int limit) throws IOException, ParseException {
        Query parsedQuery = this.parseQuery(userQuery);
        return this.explain(parsedQuery, offset, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String explain(Query query, int offset, int limit) throws IOException, ParseException {
        StringBuffer sb = new StringBuffer("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        sb.append("<html lang=\"en\">\n<head>\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
        sb.append("</head>\n<body>");
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopDocs topdocs = searcher.search(query, offset + limit);
            ScoreDoc[] docs = topdocs.scoreDocs;
            float maxScore = topdocs.getMaxScore();
            sb.append("<p>Query:" + query.toString() + "</p>\n");
            for (int i = 0; i < docs.length; ++i) {
                this.explainAndDisplayResult(i, sb, searcher, query, docs[i], maxScore);
            }
            this.searchCount.incrementAndGet();
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
        sb.append("</body>\n</html>");
        return sb.toString();
    }

    protected void explainAndDisplayResult(int i, StringBuffer sb, IndexSearcher searcher, Query query, ScoreDoc scoreDoc, float maxScore) throws IOException, ParseException {
        sb.append("<p>" + i + ":Score:" + scoreDoc.score / maxScore * 100.0f + "</p>\n");
        sb.append(this.printExplainHeader(searcher.doc(scoreDoc.doc)));
        sb.append(searcher.explain(query, scoreDoc.doc).toHtml());
    }

    protected abstract String printExplainHeader(Document var1) throws IOException, ParseException;

    public SearcherManager getSearcherManager() {
        return this.searcherManager;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }
}

