/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Recording;
import org.musicbrainz.mmd2.RecordingList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.RecordingIndexField;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class RecordingWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        RecordingList recordingList = of.createRecordingList();
        for (Result result : results.results) {
            result.setNormalizedScore(results.getMaxScore());
        }
        this.write(recordingList.getRecording(), results);
        recordingList.setCount(BigInteger.valueOf(results.getTotalHits()));
        recordingList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setRecordingList(recordingList);
    }

    public void write(List list, Results results) throws IOException {
        for (Result result : results.results) {
            this.write(list, result);
        }
    }

    public void write(List list, Result result) throws IOException {
        MbDocument doc = result.getDoc();
        Recording recording = (Recording)MMDSerializer.unserialize((String)doc.get((IndexField)RecordingIndexField.RECORDING_STORE), Recording.class);
        recording.setScore(String.valueOf(result.getNormalizedScore()));
        list.add(recording);
    }
}

