/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.LabelIndexField;
import org.musicbrainz.search.servlet.AbstractSearchServer;
import org.musicbrainz.search.servlet.LabelQueryParser;
import org.musicbrainz.search.servlet.ResourceType;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd1.LabelMmd1XmlWriter;
import org.musicbrainz.search.servlet.mmd2.LabelWriter;

public class LabelSearch
extends AbstractSearchServer {
    protected void setupDefaultFields() {
        this.defaultFields = new ArrayList();
        this.defaultFields.add(LabelIndexField.LABEL.getName());
        this.defaultFields.add(LabelIndexField.ALIAS.getName());
        this.defaultFields.add(LabelIndexField.SORTNAME.getName());
    }

    public LabelSearch() throws Exception {
        this.resultsWriter = new LabelWriter();
        this.mmd1Writer = new LabelMmd1XmlWriter();
        this.setupDefaultFields();
        this.analyzer = DatabaseIndex.getAnalyzer(LabelIndexField.class);
    }

    public LabelSearch(SearcherManager searcherManager) throws Exception {
        this();
        this.searcherManager = searcherManager;
        this.setLastServerUpdatedDate();
        this.resultsWriter.setLastServerUpdatedDate(this.getServerLastUpdatedDate());
    }

    public QueryParser getParser() {
        return new LabelQueryParser(this.defaultFields.toArray(new String[0]), this.analyzer);
    }

    protected String printExplainHeader(Document doc) throws IOException, ParseException {
        return doc.get(LabelIndexField.LABEL_ID.getName()) + ':' + doc.get(LabelIndexField.LABEL.getName()) + '\n';
    }

    protected Results processResults(IndexSearcher searcher, TopDocs topDocs, int offset) throws IOException {
        Results results = super.processResults(searcher, topDocs, offset);
        results.setResourceType(ResourceType.LABEL);
        return results;
    }
}

