/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.musicbrainz.search.LuceneVersion;
import org.musicbrainz.search.index.ArtistIndexField;
import org.musicbrainz.search.index.ArtistType;

public class ArtistQueryParser
extends MultiFieldQueryParser {
    public ArtistQueryParser(String[] strings, Analyzer analyzer) {
        super(LuceneVersion.LUCENE_VERSION, strings, analyzer);
    }

    protected Query newTermQuery(Term term) {
        if (term.field().equals(ArtistIndexField.TYPE.getName())) {
            try {
                int typeId = Integer.parseInt(term.text());
                if (typeId >= ArtistType.getMinSearchId() && typeId <= ArtistType.getMaxSearchId()) {
                    TermQuery tq = new TermQuery(new Term(term.field(), ArtistType.getBySearchId((int)typeId).getName()));
                    return tq;
                }
                return super.newTermQuery(term);
            }
            catch (NumberFormatException nfe) {
                return super.newTermQuery(term);
            }
        }
        return super.newTermQuery(term);
    }
}

