/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.StructuralNodeModifier;
import org.zaproxy.zap.view.ContextStructurePanel;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuItemContextDataDrivenNode
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 990419495607725846L;
    protected Context context;

    public PopupMenuItemContextDataDrivenNode(Context context, String name) {
        super(name, true);
        this.context = context;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.flag.popup");
    }

    @Override
    public int getParentWeight() {
        return 27060;
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public void performAction(SiteNode sn) {
        Session session = Model.getSingleton().getSession();
        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
        sessionDialog.recreateUISharedContexts(session);
        Context uiSharedContext = sessionDialog.getUISharedContext(this.context.getId());
        StringBuilder sb = new StringBuilder();
        SiteNode parent = sn.getParent();
        while (!parent.getParent().isRoot()) {
            sb.insert(0, "/");
            if (parent.isDataDriven()) {
                sb.insert(0, ".+?");
            } else {
                sb.insert(0, parent.getCleanNodeName());
            }
            parent = parent.getParent();
        }
        sb.insert(0, "/(");
        sb.insert(0, parent.getCleanNodeName());
        sb.append(")(.+?)(/.*)");
        Pattern p = Pattern.compile(sb.toString());
        uiSharedContext.addDataDrivenNodes(new StructuralNodeModifier(StructuralNodeModifier.Type.DataDrivenNode, p, uiSharedContext.getDefaultDDNName()));
        View.getSingleton().showSessionDialog(session, ContextStructurePanel.getPanelName(this.context.getId()), false);
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode sn) {
        return sn.getLevel() > 2;
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

