/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.bytecode.UnpackExNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(value=false)
public abstract class UnpackExNode
extends PNodeWithContext {
    public abstract int execute(Frame var1, int var2, Object var3, int var4, int var5);

    @Specialization(guards={"isBuiltinSequence(sequence)"})
    static int doUnpackSequence(VirtualFrame frame, int initialStackTop, PSequence sequence, int countBefore, int countAfter, @Bind Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemSliceNode getItemSliceNode, @Bind PythonLanguage language, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
        int resultStackTop;
        CompilerAsserts.partialEvaluationConstant((int)countBefore);
        CompilerAsserts.partialEvaluationConstant((int)countAfter);
        int stackTop = resultStackTop = initialStackTop + countBefore + 1 + countAfter;
        SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, sequence);
        int len = storage.length();
        int starLen = len - countBefore - countAfter;
        if (starLen < 0) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, countBefore + countAfter, len);
        }
        stackTop = UnpackExNode.moveItemsToStack(frame, inliningTarget, storage, stackTop, 0, countBefore, getItemNode);
        PList starList = PFactory.createList(language, getItemSliceNode.execute(storage, countBefore, countBefore + starLen, 1, starLen));
        frame.setObject(stackTop--, (Object)starList);
        UnpackExNode.moveItemsToStack(frame, inliningTarget, storage, stackTop, len - countAfter, countAfter, getItemNode);
        return resultStackTop;
    }

    @Fallback
    static int doUnpackIterable(VirtualFrame frame, int initialStackTop, Object collection, int countBefore, int countAfter, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notIterableProfile, @Cached ListNodes.ConstructListNode constructListNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemSliceNode getItemSliceNode, @Bind PythonLanguage language, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
        Object iterator;
        int resultStackTop;
        CompilerAsserts.partialEvaluationConstant((int)countBefore);
        CompilerAsserts.partialEvaluationConstant((int)countAfter);
        int stackTop = resultStackTop = initialStackTop + countBefore + 1 + countAfter;
        try {
            iterator = getIter.execute((Frame)frame, inliningTarget, collection);
        }
        catch (PException e) {
            e.expectTypeError(inliningTarget, notIterableProfile);
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_UNPACK_NON_ITERABLE, collection);
        }
        stackTop = UnpackExNode.moveItemsToStack(frame, inliningTarget, iterator, stackTop, 0, countBefore, countBefore + countAfter, nextNode, raiseNode);
        PList starAndAfter = constructListNode.execute((Frame)frame, iterator);
        SequenceStorage storage = starAndAfter.getSequenceStorage();
        int lenAfter = storage.length();
        if (lenAfter < countAfter) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, countBefore + countAfter, countBefore + lenAfter);
        }
        if (countAfter == 0) {
            frame.setObject(stackTop, (Object)starAndAfter);
        } else {
            int starLen = lenAfter - countAfter;
            PList starList = PFactory.createList(language, getItemSliceNode.execute(storage, 0, starLen, 1, starLen));
            frame.setObject(stackTop--, (Object)starList);
            UnpackExNode.moveItemsToStack(frame, inliningTarget, storage, stackTop, starLen, countAfter, getItemNode);
        }
        return resultStackTop;
    }

    @ExplodeLoop
    private static int moveItemsToStack(VirtualFrame frame, Node inliningTarget, Object iterator, int initialStackTop, int offset, int length, int totalLength, PyIterNextNode nextNode, PRaiseNode raiseNode) {
        CompilerAsserts.partialEvaluationConstant((int)length);
        int stackTop = initialStackTop;
        for (int i = 0; i < length; ++i) {
            try {
                Object item = nextNode.execute((Frame)frame, inliningTarget, iterator);
                frame.setObject(stackTop--, item);
                continue;
            }
            catch (IteratorExhausted e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, totalLength, offset + i);
            }
        }
        return stackTop;
    }

    @ExplodeLoop
    private static int moveItemsToStack(VirtualFrame frame, Node inliningTarget, SequenceStorage storage, int initialStackTop, int offset, int length, SequenceStorageNodes.GetItemScalarNode getItemNode) {
        CompilerAsserts.partialEvaluationConstant((int)length);
        int stackTop = initialStackTop;
        for (int i = 0; i < length; ++i) {
            frame.setObject(stackTop--, getItemNode.execute(inliningTarget, storage, offset + i));
        }
        return stackTop;
    }

    public static UnpackExNode create() {
        return UnpackExNodeGen.create();
    }

    public static UnpackExNode getUncached() {
        return UnpackExNodeGen.getUncached();
    }
}

