/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;

public abstract class JSNumberToBigIntNode
extends JavaScriptBaseNode {
    protected abstract BigInt execute(Object var1);

    public final BigInt executeBigInt(Object value) {
        BigInt result = this.executeBigIntIfNumberOrNull(value);
        if (result == null) {
            throw CompilerDirectives.shouldNotReachHere((String)"not a Number");
        }
        return result;
    }

    public final BigInt executeBigIntIfNumberOrNull(Object value) {
        return this.execute(value);
    }

    @Specialization
    protected static BigInt doInteger(int value) {
        return BigInt.valueOf(value);
    }

    @Specialization
    protected static BigInt doSafeInteger(SafeInteger value) {
        return BigInt.valueOf(value.longValue());
    }

    protected static boolean doubleRepresentsSameValueAsLong(double value) {
        return JSRuntime.doubleIsRepresentableAsLong(value) && value != 9.223372036854776E18;
    }

    @Specialization(guards={"doubleRepresentsSameValueAsLong(value)"})
    protected static BigInt doDoubleAsLong(double value) {
        return BigInt.valueOf((long)value);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!doubleRepresentsSameValueAsLong(value)"})
    protected static BigInt doDoubleOther(double value) {
        if (!JSRuntime.isInteger(value)) {
            throw Errors.createRangeError("BigInt out of range");
        }
        return new BigInt(JSRuntime.toBigInteger(value));
    }

    @Fallback
    protected static BigInt doOtherType(Object value) {
        return null;
    }
}

