/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.StringModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.StringModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.str.TemplateFormatter;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_string")
public final class StringModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StringModuleBuiltinsFactory.getFactories();
    }

    private static PSequenceIterator parserListToIterator(List<Object[]> parserList, PythonLanguage language) {
        Object[] tuples = new Object[parserList.size()];
        for (int i = 0; i < tuples.length; ++i) {
            tuples[i] = PFactory.createTuple(language, parserList.get(i));
        }
        return PFactory.createSequenceIterator(language, PFactory.createList(language, tuples));
    }

    @Builtin(name="formatter_field_name_split", minNumOfPositionalArgs=1, parameterNames={"self"})
    @ArgumentClinic(name="self", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class FormatterFieldNameSplitNode
    extends PythonUnaryClinicBuiltinNode {
        FormatterFieldNameSplitNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringModuleBuiltinsClinicProviders.FormatterFieldNameSplitNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object formatterParser(VirtualFrame frame, TruffleString self, @Cached(value="createFor($node)") IndirectCallData indirectCallData) {
            TemplateFormatter.FieldNameSplitResult result;
            TemplateFormatter formatter = new TemplateFormatter(self);
            PythonContext context = PythonContext.get(this);
            PythonLanguage language = context.getLanguage(this);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                result = formatter.formatterFieldNameSplit(this);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
            return PFactory.createTuple(language, new Object[]{result.first, StringModuleBuiltins.parserListToIterator(result.parserList, language)});
        }
    }

    @Builtin(name="formatter_parser", minNumOfPositionalArgs=1, parameterNames={"self"})
    @ArgumentClinic(name="self", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class FormaterParserNode
    extends PythonUnaryClinicBuiltinNode {
        FormaterParserNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringModuleBuiltinsClinicProviders.FormaterParserNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        PSequenceIterator formatterParser(VirtualFrame frame, TruffleString self, @Cached(value="createFor($node)") IndirectCallData indirectCallData) {
            List<Object[]> parserList;
            TemplateFormatter formatter = new TemplateFormatter(self);
            PythonContext context = PythonContext.get(this);
            PythonLanguage language = context.getLanguage(this);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                parserList = formatter.formatterParser(this);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
            return StringModuleBuiltins.parserListToIterator(parserList, language);
        }
    }
}

