/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler;

import com.strobel.assembler.ir.ExceptionHandler;
import com.strobel.assembler.ir.Frame;
import com.strobel.assembler.ir.FrameType;
import com.strobel.assembler.ir.FrameValue;
import com.strobel.assembler.ir.FrameValueType;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.InstructionBlock;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.ICompoundType;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.MethodHandle;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.ParameterReference;
import com.strobel.assembler.metadata.SwitchInfo;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableReference;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.NameSyntax;
import com.strobel.decompiler.ast.Variable;
import java.util.List;
import java.util.Stack;

public final class DecompilerHelpers {
    public static void writeType(ITextOutput writer, TypeReference type) {
        DecompilerHelpers.writeType(writer, type, NameSyntax.SIGNATURE);
    }

    public static void writeGenericSignature(ITextOutput writer, TypeReference type) {
        DecompilerHelpers.formatGenericSignature(writer, type, new Stack<TypeReference>());
    }

    public static void writeType(ITextOutput writer, TypeReference type, NameSyntax syntax) {
        VerifyArgument.notNull(type, "type");
        VerifyArgument.notNull(writer, "writer");
        VerifyArgument.notNull(syntax, "syntax");
        DecompilerHelpers.formatType(writer, type, syntax, type.isDefinition(), new Stack<TypeReference>());
    }

    public static void writeType(ITextOutput writer, TypeReference type, NameSyntax syntax, boolean isDefinition) {
        VerifyArgument.notNull(type, "type");
        VerifyArgument.notNull(writer, "writer");
        VerifyArgument.notNull(syntax, "syntax");
        DecompilerHelpers.formatType(writer, type, syntax, isDefinition, new Stack<TypeReference>());
    }

    public static void writeMethod(ITextOutput writer, MethodReference method) {
        VerifyArgument.notNull(method, "method");
        VerifyArgument.notNull(writer, "writer");
        Stack<TypeReference> typeStack = new Stack<TypeReference>();
        DecompilerHelpers.formatType(writer, method.getDeclaringType(), NameSyntax.DESCRIPTOR, false, typeStack);
        writer.writeDelimiter(".");
        writer.writeReference(method.getName(), method);
        writer.writeDelimiter(":");
        DecompilerHelpers.formatMethodSignature(writer, method, typeStack);
    }

    public static void writeMethodSignature(ITextOutput writer, IMethodSignature signature) {
        VerifyArgument.notNull(signature, "signature");
        VerifyArgument.notNull(writer, "writer");
        Stack<TypeReference> typeStack = new Stack<TypeReference>();
        DecompilerHelpers.formatMethodSignature(writer, signature, typeStack);
    }

    public static void writeMethodHandle(ITextOutput writer, MethodHandle handle) {
        VerifyArgument.notNull(handle, "handle");
        VerifyArgument.notNull(writer, "writer");
        writer.writeReference(handle.getHandleType().name().toLowerCase(), (Object)handle.getHandleType());
        writer.write(' ');
        DecompilerHelpers.writeMethod(writer, handle.getMethod());
    }

    public static void writeField(ITextOutput writer, FieldReference field) {
        VerifyArgument.notNull(field, "field");
        VerifyArgument.notNull(writer, "writer");
        Stack<TypeReference> typeStack = new Stack<TypeReference>();
        DecompilerHelpers.formatType(writer, field.getDeclaringType(), NameSyntax.DESCRIPTOR, false, typeStack);
        writer.writeDelimiter(".");
        writer.writeReference(field.getName(), field);
        writer.writeDelimiter(":");
        DecompilerHelpers.formatType(writer, field.getFieldType(), NameSyntax.SIGNATURE, false, typeStack);
    }

    public static void writeOperand(ITextOutput writer, Object operand) {
        DecompilerHelpers.writeOperand(writer, operand, false);
    }

    public static void writeOperand(ITextOutput writer, Object operand, boolean isUnicodeSupported) {
        VerifyArgument.notNull(writer, "writer");
        VerifyArgument.notNull(operand, "operand");
        if (operand instanceof Instruction) {
            Instruction targetInstruction = (Instruction)operand;
            DecompilerHelpers.writeOffsetReference(writer, targetInstruction);
            return;
        }
        if (operand instanceof Instruction[]) {
            Instruction[] targetInstructions = (Instruction[])operand;
            DecompilerHelpers.writeLabelList(writer, targetInstructions);
            return;
        }
        if (operand instanceof SwitchInfo) {
            SwitchInfo switchInfo = (SwitchInfo)operand;
            writer.write('[');
            DecompilerHelpers.writeOffsetReference(writer, switchInfo.getDefaultTarget());
            for (Instruction target : switchInfo.getTargets()) {
                writer.write(", ");
                DecompilerHelpers.writeOffsetReference(writer, target);
            }
            writer.write(']');
            return;
        }
        if (operand instanceof VariableReference) {
            VariableReference variable = (VariableReference)operand;
            if (variable.hasName()) {
                writer.writeReference(DecompilerHelpers.escapeIdentifier(variable.getName()), variable);
            } else {
                writer.writeReference("$" + String.valueOf(variable.getSlot()), variable);
            }
            return;
        }
        if (operand instanceof ParameterReference) {
            ParameterReference parameter = (ParameterReference)operand;
            String parameterName = parameter.getName();
            if (StringUtilities.isNullOrEmpty(parameterName)) {
                writer.writeReference(String.valueOf(parameter.getPosition()), parameter);
            } else {
                writer.writeReference(DecompilerHelpers.escapeIdentifier(parameterName), parameter);
            }
            return;
        }
        if (operand instanceof Variable) {
            Variable variable = (Variable)operand;
            if (variable.isParameter()) {
                writer.writeReference(variable.getName(), variable.getOriginalParameter());
            } else {
                writer.writeReference(variable.getName(), variable.getOriginalVariable());
            }
            return;
        }
        if (operand instanceof MethodReference) {
            DecompilerHelpers.writeMethod(writer, (MethodReference)operand);
            return;
        }
        if (operand instanceof IMethodSignature) {
            DecompilerHelpers.writeMethodSignature(writer, (IMethodSignature)operand);
            return;
        }
        if (operand instanceof MethodHandle) {
            DecompilerHelpers.writeMethodHandle(writer, (MethodHandle)operand);
            return;
        }
        if (operand instanceof TypeReference) {
            DecompilerHelpers.writeType(writer, (TypeReference)operand, NameSyntax.TYPE_NAME);
            writer.write('.');
            writer.writeKeyword("class");
            return;
        }
        if (operand instanceof FieldReference) {
            DecompilerHelpers.writeField(writer, (FieldReference)operand);
            return;
        }
        if (operand instanceof DynamicCallSite) {
            DecompilerHelpers.writeDynamicCallSite(writer, (DynamicCallSite)operand);
            return;
        }
        DecompilerHelpers.writePrimitiveValue(writer, operand);
    }

    public static void writeDynamicCallSite(ITextOutput output, DynamicCallSite operand) {
        DecompilerHelpers.writeMethodHandle(output, operand.getBootstrapMethodHandle());
        output.write(", ");
        output.writeReference(operand.getMethodName(), operand.getMethodType());
        output.writeDelimiter(":");
        DecompilerHelpers.writeMethodSignature(output, operand.getMethodType());
        DecompilerHelpers.writeOperandList(output, operand.getBootstrapArguments());
    }

    public static String offsetToString(int offset) {
        return String.format("#%1$04d", offset);
    }

    public static void writeExceptionHandler(ITextOutput output, ExceptionHandler handler) {
        VerifyArgument.notNull(output, "output");
        VerifyArgument.notNull(handler, "handler");
        output.write("Try ");
        DecompilerHelpers.writeOffsetReference(output, handler.getTryBlock().getFirstInstruction());
        output.write(" - ");
        DecompilerHelpers.writeEndOffsetReference(output, handler.getTryBlock().getLastInstruction());
        output.write(' ');
        output.write(String.valueOf((Object)handler.getHandlerType()));
        TypeReference catchType = handler.getCatchType();
        if (catchType != null) {
            output.write(' ');
            DecompilerHelpers.writeType(output, catchType);
        }
        InstructionBlock handlerBlock = handler.getHandlerBlock();
        output.write(' ');
        DecompilerHelpers.writeOffsetReference(output, handlerBlock.getFirstInstruction());
        if (handlerBlock.getLastInstruction() != null) {
            output.write(" - ");
            DecompilerHelpers.writeEndOffsetReference(output, handlerBlock.getLastInstruction());
        }
    }

    public static void writeInstruction(ITextOutput writer, Instruction instruction) {
        VerifyArgument.notNull(writer, "writer");
        VerifyArgument.notNull(instruction, "instruction");
        writer.writeDefinition(DecompilerHelpers.offsetToString(instruction.getOffset()), instruction);
        writer.write(": ");
        writer.writeReference(instruction.getOpCode().name(), (Object)instruction.getOpCode());
        if (instruction.hasOperand()) {
            writer.write(' ');
            DecompilerHelpers.writeOperandList(writer, instruction);
        }
    }

    public static void writeOffsetReference(ITextOutput writer, Instruction instruction) {
        VerifyArgument.notNull(writer, "writer");
        writer.writeLabel(DecompilerHelpers.offsetToString(instruction.getOffset()));
    }

    public static void writeEndOffsetReference(ITextOutput writer, Instruction instruction) {
        VerifyArgument.notNull(writer, "writer");
        writer.writeLabel(DecompilerHelpers.offsetToString(instruction.getEndOffset()));
    }

    public static String escapeIdentifier(String name) {
        VerifyArgument.notNull(name, "name");
        StringBuilder sb = null;
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char ch = name.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(ch)) continue;
                sb = new StringBuilder(name.length() * 2);
                sb.append(String.format("\\u%1$04x", ch));
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                if (sb == null) continue;
                sb.append(ch);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(name.length() * 2);
            }
            sb.append(String.format("\\u%1$04x", ch));
        }
        if (sb != null) {
            return sb.toString();
        }
        return name;
    }

    public static void writeFrame(ITextOutput writer, Frame frame) {
        FrameValue value;
        int i;
        VerifyArgument.notNull(writer, "writer");
        VerifyArgument.notNull(frame, "frame");
        FrameType frameType = frame.getFrameType();
        writer.writeLiteral(String.valueOf((Object)frameType));
        List<FrameValue> localValues = frame.getLocalValues();
        List<FrameValue> stackValues = frame.getStackValues();
        if (!localValues.isEmpty()) {
            writer.writeLine();
            writer.indent();
            writer.write("Locals: ");
            writer.writeDelimiter("[");
            for (i = 0; i < localValues.size(); ++i) {
                value = localValues.get(i);
                if (i != 0) {
                    writer.writeDelimiter(", ");
                }
                if (value.getType() == FrameValueType.Reference) {
                    writer.writeLiteral("Reference");
                    writer.writeDelimiter("(");
                    DecompilerHelpers.writeType(writer, (TypeReference)value.getParameter(), NameSyntax.SIGNATURE);
                    writer.writeDelimiter(")");
                    continue;
                }
                writer.writeLiteral(String.valueOf((Object)value.getType()));
            }
            writer.writeDelimiter("]");
            writer.unindent();
        }
        if (!stackValues.isEmpty()) {
            writer.writeLine();
            writer.indent();
            writer.write("Stack: ");
            writer.writeDelimiter("[");
            for (i = 0; i < stackValues.size(); ++i) {
                value = stackValues.get(i);
                if (i != 0) {
                    writer.writeDelimiter(", ");
                }
                if (value.getType() == FrameValueType.Reference) {
                    writer.writeLiteral("Reference");
                    writer.writeDelimiter("(");
                    DecompilerHelpers.writeType(writer, (TypeReference)value.getParameter(), NameSyntax.SIGNATURE);
                    writer.writeDelimiter(")");
                    continue;
                }
                writer.writeLiteral(String.valueOf((Object)value.getType()));
            }
            writer.writeDelimiter("]");
            writer.unindent();
        }
    }

    private static void writeLabelList(ITextOutput writer, Instruction[] instructions) {
        writer.write('(');
        for (int i = 0; i < instructions.length; ++i) {
            if (i != 0) {
                writer.write(", ");
            }
            DecompilerHelpers.writeOffsetReference(writer, instructions[i]);
        }
        writer.write(')');
    }

    private static void writeOperandList(ITextOutput writer, Instruction instruction) {
        int n = instruction.getOperandCount();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                writer.write(", ");
            }
            DecompilerHelpers.writeOperand(writer, instruction.getOperand(i));
        }
    }

    private static void writeOperandList(ITextOutput writer, List<?> operands) {
        int n = operands.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                writer.write(", ");
            }
            DecompilerHelpers.writeOperand(writer, operands.get(i));
        }
    }

    private static void formatMethodSignature(ITextOutput writer, IMethodSignature signature, Stack<TypeReference> typeStack) {
        List<GenericParameter> genericParameters;
        int count;
        if (signature.isGenericDefinition() && (count = (genericParameters = signature.getGenericParameters()).size()) > 0) {
            writer.writeDelimiter("<");
            for (int i = 0; i < count; ++i) {
                DecompilerHelpers.formatGenericSignature(writer, genericParameters.get(i), typeStack);
            }
            writer.writeDelimiter(">");
        }
        List<ParameterDefinition> parameters = signature.getParameters();
        writer.writeDelimiter("(");
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterDefinition p = parameters.get(i);
            if (p.isSynthetic()) continue;
            DecompilerHelpers.formatType(writer, p.getParameterType(), NameSyntax.SIGNATURE, false, typeStack);
        }
        writer.writeDelimiter(")");
        DecompilerHelpers.formatType(writer, signature.getReturnType(), NameSyntax.SIGNATURE, false, typeStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void formatType(ITextOutput writer, TypeReference type, NameSyntax syntax, boolean isDefinition, Stack<TypeReference> stack) {
        if (type.isGenericParameter()) {
            switch (syntax) {
                case SIGNATURE: 
                case ERASED_SIGNATURE: 
                case DESCRIPTOR: {
                    writer.writeDelimiter("T");
                    writer.writeReference(type.getSimpleName(), type);
                    writer.writeDelimiter(";");
                    return;
                }
            }
            writer.writeReference(type.getName(), type);
            if (isDefinition && type.hasExtendsBound() && !stack.contains(type.getExtendsBound()) && !BuiltinTypes.Object.equals(type.getExtendsBound())) {
                writer.writeKeyword(" extends ");
                stack.push(type);
                try {
                    DecompilerHelpers.formatType(writer, type.getExtendsBound(), syntax, false, stack);
                }
                finally {
                    stack.pop();
                }
            }
            return;
        }
        if (type.isWildcardType()) {
            switch (syntax) {
                case DESCRIPTOR: {
                    DecompilerHelpers.formatType(writer, type.getExtendsBound(), syntax, false, stack);
                    return;
                }
                case SIGNATURE: 
                case ERASED_SIGNATURE: {
                    if (type.hasSuperBound()) {
                        writer.write('-');
                        DecompilerHelpers.formatType(writer, type.getSuperBound(), syntax, false, stack);
                    } else if (type.hasExtendsBound()) {
                        writer.write('+');
                        DecompilerHelpers.formatType(writer, type.getExtendsBound(), syntax, false, stack);
                    } else {
                        writer.write('*');
                    }
                    return;
                }
            }
            writer.write("?");
            if (type.hasSuperBound()) {
                writer.writeKeyword(" super ");
                DecompilerHelpers.formatType(writer, type.getSuperBound(), syntax, false, stack);
            } else if (type.hasExtendsBound()) {
                writer.writeKeyword(" extends ");
                DecompilerHelpers.formatType(writer, type.getExtendsBound(), syntax, false, stack);
            }
            return;
        }
        if (type instanceof ICompoundType) {
            ICompoundType compoundType = (ICompoundType)((Object)type);
            TypeReference baseType = compoundType.getBaseType();
            List<TypeReference> interfaces = compoundType.getInterfaces();
            switch (syntax) {
                case SIGNATURE: {
                    if (baseType != null) {
                        DecompilerHelpers.formatType(writer, baseType, syntax, false, stack);
                    }
                    for (TypeReference interfaceType : interfaces) {
                        writer.writeDelimiter(":");
                        DecompilerHelpers.formatType(writer, interfaceType, syntax, false, stack);
                    }
                    break;
                }
                case ERASED_SIGNATURE: 
                case DESCRIPTOR: {
                    TypeReference erasedType = baseType != null ? baseType : (!interfaces.isEmpty() ? interfaces.get(0) : BuiltinTypes.Object);
                    DecompilerHelpers.formatType(writer, erasedType, syntax, false, stack);
                    break;
                }
                case TYPE_NAME: 
                case SHORT_TYPE_NAME: {
                    boolean first = true;
                    if (baseType != null) {
                        DecompilerHelpers.formatType(writer, baseType, syntax, false, stack);
                        first = false;
                    }
                    for (TypeReference interfaceType : interfaces) {
                        if (!first) {
                            writer.writeDelimiter(" & ");
                        }
                        DecompilerHelpers.formatType(writer, interfaceType, syntax, false, stack);
                        first = false;
                    }
                    break;
                }
            }
            return;
        }
        if (type.isArray()) {
            switch (syntax) {
                case SIGNATURE: 
                case ERASED_SIGNATURE: 
                case DESCRIPTOR: {
                    writer.writeDelimiter("[");
                    DecompilerHelpers.formatType(writer, type.getElementType(), syntax, false, stack);
                    break;
                }
                case TYPE_NAME: 
                case SHORT_TYPE_NAME: {
                    DecompilerHelpers.formatType(writer, type.getElementType(), syntax, false, stack);
                    writer.writeDelimiter("[]");
                }
            }
            return;
        }
        stack.push(type);
        TypeDefinition resolvedType = type.resolve();
        TypeReference nameSource = resolvedType != null ? resolvedType : type;
        try {
            String name;
            switch (syntax) {
                case TYPE_NAME: {
                    name = nameSource.getFullName();
                    break;
                }
                case SHORT_TYPE_NAME: {
                    name = nameSource.getSimpleName();
                    break;
                }
                case DESCRIPTOR: {
                    name = nameSource.getInternalName();
                    break;
                }
                default: {
                    if (nameSource.isPrimitive()) {
                        name = nameSource.getInternalName();
                        break;
                    }
                    writer.writeDelimiter("L");
                    name = nameSource.getInternalName();
                }
            }
            if (type.isPrimitive() && (syntax == NameSyntax.TYPE_NAME || syntax == NameSyntax.SHORT_TYPE_NAME)) {
                writer.writeKeyword(name);
            } else if (isDefinition) {
                writer.writeDefinition(name, type);
            } else {
                writer.writeReference(name, type);
            }
            if (type.isGenericType() && syntax != NameSyntax.DESCRIPTOR && syntax != NameSyntax.ERASED_SIGNATURE) {
                stack.push(type);
                try {
                    List<TypeReference> typeArguments = type instanceof IGenericInstance ? ((IGenericInstance)((Object)type)).getTypeArguments() : type.getGenericParameters();
                    int count = typeArguments.size();
                    if (count > 0) {
                        writer.writeDelimiter("<");
                        for (int i = 0; i < count; ++i) {
                            if (syntax != NameSyntax.SIGNATURE && i != 0) {
                                writer.writeDelimiter(", ");
                            }
                            TypeReference typeArgument = typeArguments.get(i);
                            DecompilerHelpers.formatType(writer, typeArgument, syntax, false, stack);
                        }
                        writer.writeDelimiter(">");
                    }
                }
                finally {
                    stack.pop();
                }
            }
            if (!(type.isPrimitive() || syntax != NameSyntax.SIGNATURE && syntax != NameSyntax.ERASED_SIGNATURE)) {
                writer.writeDelimiter(";");
            }
        }
        finally {
            stack.pop();
        }
    }

    private static void formatGenericSignature(ITextOutput writer, TypeReference type, Stack<TypeReference> stack) {
        TypeDefinition definition;
        List<TypeReference> typeArguments;
        int count;
        if (type.isGenericParameter()) {
            TypeReference extendsBound = type.getExtendsBound();
            TypeDefinition resolvedBound = extendsBound.resolve();
            writer.writeDefinition(type.getName(), type);
            if (resolvedBound != null && resolvedBound.isInterface()) {
                writer.writeDelimiter(":");
            }
            writer.writeDelimiter(":");
            DecompilerHelpers.formatType(writer, extendsBound, NameSyntax.SIGNATURE, false, stack);
            return;
        }
        if (type.isGenericType() && (count = (typeArguments = type instanceof IGenericInstance ? ((IGenericInstance)((Object)type)).getTypeArguments() : type.getGenericParameters()).size()) > 0) {
            writer.writeDelimiter("<");
            for (int i = 0; i < count; ++i) {
                DecompilerHelpers.formatGenericSignature(writer, typeArguments.get(i), stack);
            }
            writer.writeDelimiter(">");
        }
        if ((definition = type.resolve()) == null) {
            return;
        }
        TypeReference baseType = definition.getBaseType();
        List<TypeReference> interfaces = definition.getExplicitInterfaces();
        if (baseType == null) {
            DecompilerHelpers.formatType(writer, BuiltinTypes.Object, NameSyntax.SIGNATURE, false, stack);
        } else {
            DecompilerHelpers.formatType(writer, baseType, NameSyntax.SIGNATURE, false, stack);
        }
        for (TypeReference interfaceType : interfaces) {
            DecompilerHelpers.formatType(writer, interfaceType, NameSyntax.SIGNATURE, false, stack);
        }
    }

    public static void writePrimitiveValue(ITextOutput output, Object value) {
        if (value == null) {
            output.writeKeyword("null");
            return;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                output.writeKeyword("true");
            } else {
                output.writeKeyword("false");
            }
            return;
        }
        if (value instanceof String) {
            output.writeTextLiteral(StringUtilities.escape(value.toString(), true, true));
        } else if (value instanceof Character) {
            output.writeTextLiteral(StringUtilities.escape(((Character)value).charValue(), true, true));
        } else if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            if (Float.isInfinite(f) || Float.isNaN(f)) {
                output.writeReference("Float", MetadataSystem.instance().lookupType("java/lang/Float"));
                output.writeDelimiter(".");
                if (f == Float.POSITIVE_INFINITY) {
                    output.write("POSITIVE_INFINITY");
                } else if (f == Float.NEGATIVE_INFINITY) {
                    output.write("NEGATIVE_INFINITY");
                } else {
                    output.write("NaN");
                }
                return;
            }
            output.writeLiteral(Float.toString(f) + "f");
        } else if (value instanceof Double) {
            double d = (Double)value;
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                TypeReference doubleType = MetadataSystem.instance().lookupType("java/lang/Double");
                output.writeReference("Double", doubleType);
                output.writeDelimiter(".");
                if (d == Double.POSITIVE_INFINITY) {
                    output.write("POSITIVE_INFINITY");
                } else if (d == Double.NEGATIVE_INFINITY) {
                    output.write("NEGATIVE_INFINITY");
                } else {
                    output.write("NaN");
                }
                return;
            }
            String number = Double.toString(d);
            if (number.indexOf(46) < 0 && number.indexOf(69) < 0) {
                number = number + "d";
            }
            output.writeLiteral(number);
        } else if (value instanceof Long) {
            output.writeLiteral(String.valueOf(value) + "L");
        } else {
            output.writeLiteral(String.valueOf(value));
        }
    }
}

