/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

public enum UsageEnum {
    USER_APPLICATIONS(0),
    DIRECTORY_OPERATION(1),
    DISTRIBUTED_OPERATION(2),
    DSA_OPERATION(3);

    private int value;

    private UsageEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static UsageEnum getUsage(String usage) {
        try {
            return UsageEnum.valueOf(usage);
        }
        catch (IllegalArgumentException iae) {
            if ("directoryOperation".equalsIgnoreCase(usage)) {
                return DIRECTORY_OPERATION;
            }
            if ("distributedOperation".equalsIgnoreCase(usage)) {
                return DISTRIBUTED_OPERATION;
            }
            if ("dSAOperation".equalsIgnoreCase(usage)) {
                return DSA_OPERATION;
            }
            if ("userApplications".equalsIgnoreCase(usage)) {
                return USER_APPLICATIONS;
            }
            return null;
        }
    }

    public static String render(UsageEnum usage) {
        if (usage == null) {
            return "userApplications";
        }
        switch (usage) {
            case DIRECTORY_OPERATION: {
                return "directoryOperation";
            }
            case DISTRIBUTED_OPERATION: {
                return "distributedOperation";
            }
            case DSA_OPERATION: {
                return "dSAOperation";
            }
            case USER_APPLICATIONS: {
                return "userApplications";
            }
        }
        return "";
    }

    public String render() {
        return UsageEnum.render(this);
    }
}

