/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.ICOSParser;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadView;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.BruteForceParser;
import org.apache.pdfbox.pdfparser.EndstreamFilterStream;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdfparser.PDFXrefStreamParser;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.util.StringUtil;

public class COSParser
extends BaseParser
implements ICOSParser {
    private static final String PDF_HEADER = "%PDF-";
    private static final String FDF_HEADER = "%FDF-";
    private static final String PDF_DEFAULT_VERSION = "1.4";
    private static final String FDF_DEFAULT_VERSION = "1.0";
    private static final char[] XREF_TABLE = new char[]{'x', 'r', 'e', 'f'};
    private static final char[] STARTXREF = new char[]{'s', 't', 'a', 'r', 't', 'x', 'r', 'e', 'f'};
    private static final byte[] ENDSTREAM = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    private static final byte[] ENDOBJ = new byte[]{101, 110, 100, 111, 98, 106};
    private static final long MINIMUM_SEARCH_OFFSET = 6L;
    private static final int X = 120;
    private static final int STRMBUFLEN = 2048;
    private final byte[] strmBuf = new byte[2048];
    private AccessPermission accessPermission;
    private InputStream keyStoreInputStream = null;
    private String password = "";
    private String keyAlias = null;
    public static final String SYSPROP_EOFLOOKUPRANGE = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange";
    private static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    protected static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    protected static final char[] OBJ_MARKER = new char[]{'o', 'b', 'j'};
    protected long fileLen;
    private boolean isLenient = true;
    protected boolean initialParseDone = false;
    private boolean trailerWasRebuild = false;
    private BruteForceParser bruteForceParser = null;
    private PDEncryption encryption = null;
    private final Map<Long, Map<COSObjectKey, COSBase>> decompressedObjects = new HashMap<Long, Map<COSObjectKey, COSBase>>();
    protected SecurityHandler<? extends ProtectionPolicy> securityHandler = null;
    private int readTrailBytes = 2048;
    private static final Log LOG = LogFactory.getLog(COSParser.class);
    protected XrefTrailerResolver xrefTrailerResolver = new XrefTrailerResolver();

    public COSParser(RandomAccessRead source) throws IOException {
        this(source, null, null, null);
    }

    public COSParser(RandomAccessRead source, String password, InputStream keyStore, String keyAlias) throws IOException {
        this(source, password, keyStore, keyAlias, null);
    }

    public COSParser(RandomAccessRead source, String password, InputStream keyStore, String keyAlias, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) throws IOException {
        super(source);
        this.password = password;
        this.keyAlias = keyAlias;
        this.fileLen = source.length();
        this.keyStoreInputStream = keyStore;
        this.init(streamCacheCreateFunction);
    }

    private void init(RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) {
        String eofLookupRangeStr = System.getProperty(SYSPROP_EOFLOOKUPRANGE);
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'"));
            }
        }
        this.document = new COSDocument(streamCacheCreateFunction, this);
    }

    public void setEOFLookupRange(int byteCount) {
        if (byteCount > 15) {
            this.readTrailBytes = byteCount;
        }
    }

    protected COSDictionary retrieveTrailer() throws IOException {
        COSDictionary trailer = null;
        boolean rebuildTrailer = false;
        try {
            long startXRefOffset = this.getStartxrefOffset();
            if (startXRefOffset > -1L) {
                trailer = this.parseXref(startXRefOffset);
            } else {
                rebuildTrailer = this.isLenient();
            }
        }
        catch (IOException exception) {
            if (this.isLenient()) {
                rebuildTrailer = true;
            }
            throw exception;
        }
        if (trailer != null && trailer.getItem(COSName.ROOT) == null) {
            rebuildTrailer = this.isLenient();
        }
        if (rebuildTrailer) {
            trailer = this.getBruteForceParser().rebuildTrailer(this.xrefTrailerResolver, null);
            this.trailerWasRebuild = true;
            this.encryption = this.getBruteForceParser().getEncryption();
            if (this.encryption != null) {
                this.securityHandler = this.encryption.getSecurityHandler();
                this.accessPermission = this.securityHandler.getCurrentAccessPermission();
            }
        } else {
            this.prepareDecryption();
            if (this.bruteForceParser != null && this.bruteForceParser.bfSearchTriggered()) {
                this.getBruteForceParser().bfSearchForObjStreams(this.xrefTrailerResolver, this.securityHandler);
            }
        }
        if (this.resetTrailerResolver()) {
            this.xrefTrailerResolver.reset();
            this.xrefTrailerResolver = null;
        }
        return trailer;
    }

    protected boolean resetTrailerResolver() {
        return true;
    }

    private COSDictionary parseXref(long startXRefOffset) throws IOException {
        this.source.seek(startXRefOffset);
        long startXrefOffset = Math.max(0L, this.parseStartXref());
        long fixedOffset = this.checkXRefOffset(startXrefOffset);
        if (fixedOffset > -1L) {
            startXrefOffset = fixedOffset;
        }
        this.document.setStartXref(startXrefOffset);
        long prev = startXrefOffset;
        HashSet<Long> prevSet = new HashSet<Long>();
        COSDictionary trailer = null;
        while (prev > 0L) {
            prevSet.add(prev);
            this.source.seek(prev);
            this.skipSpaces();
            prevSet.add(this.source.getPosition());
            if (this.source.peek() == 120) {
                if (!this.parseXrefTable(prev) || !this.parseTrailer()) {
                    throw new IOException("Expected trailer object at offset " + this.source.getPosition());
                }
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
                if (trailer.containsKey(COSName.XREF_STM)) {
                    int streamOffset = trailer.getInt(COSName.XREF_STM);
                    fixedOffset = this.checkXRefOffset(streamOffset);
                    if (fixedOffset > -1L && fixedOffset != (long)streamOffset) {
                        LOG.warn((Object)("/XRefStm offset " + streamOffset + " is incorrect, corrected to " + fixedOffset));
                        streamOffset = (int)fixedOffset;
                        trailer.setInt(COSName.XREF_STM, streamOffset);
                    }
                    if (streamOffset > 0) {
                        this.source.seek((long)streamOffset);
                        this.skipSpaces();
                        try {
                            this.parseXrefObjStream(prev, false);
                            this.document.setHasHybridXRef();
                        }
                        catch (IOException ex) {
                            if (this.isLenient) {
                                LOG.error((Object)("Failed to parse /XRefStm at offset " + streamOffset), (Throwable)ex);
                            }
                            throw ex;
                        }
                    } else if (this.isLenient) {
                        LOG.error((Object)("Skipped XRef stream due to a corrupt offset:" + streamOffset));
                    } else {
                        throw new IOException("Skipped XRef stream due to a corrupt offset:" + streamOffset);
                    }
                }
                prev = trailer.getLong(COSName.PREV);
            } else {
                prev = this.parseXrefObjStream(prev, true);
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
            }
            if (prev > 0L && (fixedOffset = this.checkXRefOffset(prev)) > -1L && fixedOffset != prev) {
                prev = fixedOffset;
                trailer.setLong(COSName.PREV, prev);
            }
            if (!prevSet.contains(prev)) continue;
            throw new IOException("/Prev loop at offset " + prev);
        }
        this.xrefTrailerResolver.setStartxref(startXrefOffset);
        trailer = this.xrefTrailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        this.document.setIsXRefStream(XrefTrailerResolver.XRefType.STREAM == this.xrefTrailerResolver.getXrefType());
        if (this.isLenient) {
            this.checkXrefOffsets();
        }
        this.document.addXRefTable(this.xrefTrailerResolver.getXrefTable());
        Optional<Long> maxValue = this.document.getXrefTable().keySet().stream().map(COSObjectKey::getNumber).reduce(Long::max);
        this.document.setHighestXRefObjectNumber(maxValue.isPresent() ? maxValue.get() : 0L);
        return trailer;
    }

    private long parseXrefObjStream(long objByteOffset, boolean isStandalone) throws IOException {
        this.readObjectNumber();
        this.readGenerationNumber();
        this.readExpectedString(OBJ_MARKER, true);
        COSDictionary dict = this.parseCOSDictionary(false);
        try (COSStream xrefStream = this.parseCOSStream(dict);){
            if (isStandalone) {
                this.xrefTrailerResolver.nextXrefObj(objByteOffset, XrefTrailerResolver.XRefType.STREAM);
                this.xrefTrailerResolver.setTrailer(xrefStream);
            }
            PDFXrefStreamParser parser = new PDFXrefStreamParser(xrefStream, this.document);
            parser.parse(this.xrefTrailerResolver);
        }
        return dict.getLong(COSName.PREV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getStartxrefOffset() throws IOException {
        long skipBytes;
        byte[] buf;
        try {
            int readBytes;
            int trailByteCount = this.fileLen < (long)this.readTrailBytes ? (int)this.fileLen : this.readTrailBytes;
            buf = new byte[trailByteCount];
            skipBytes = this.fileLen - (long)trailByteCount;
            this.source.seek(skipBytes);
            for (int off = 0; off < trailByteCount; off += readBytes) {
                readBytes = this.source.read(buf, off, trailByteCount - off);
                if (readBytes >= 1) continue;
                throw new IOException("No more bytes to read for trailing buffer, but expected: " + (trailByteCount - off));
            }
        }
        finally {
            this.source.seek(0L);
        }
        int bufOff = this.lastIndexOf(EOF_MARKER, buf, buf.length);
        if (bufOff < 0) {
            if (this.isLenient) {
                bufOff = buf.length;
                LOG.debug((Object)("Missing end of file marker '" + new String(EOF_MARKER) + "'"));
            } else {
                throw new IOException("Missing end of file marker '" + new String(EOF_MARKER) + "'");
            }
        }
        if ((bufOff = this.lastIndexOf(STARTXREF, buf, bufOff)) < 0) {
            throw new IOException("Missing 'startxref' marker.");
        }
        return skipBytes + (long)bufOff;
    }

    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int lastPatternChOff = pattern.length - 1;
        int bufOff = endOff;
        int patOff = lastPatternChOff;
        char lookupCh = pattern[patOff];
        while (--bufOff >= 0) {
            if (buf[bufOff] == lookupCh) {
                if (--patOff < 0) {
                    return bufOff;
                }
                lookupCh = pattern[patOff];
                continue;
            }
            if (patOff >= lastPatternChOff) continue;
            patOff = lastPatternChOff;
            lookupCh = pattern[patOff];
        }
        return -1;
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    protected void setLenient(boolean lenient) {
        if (this.initialParseDone) {
            throw new IllegalArgumentException("Cannot change leniency after parsing");
        }
        this.isLenient = lenient;
    }

    @Override
    public COSBase dereferenceCOSObject(COSObject obj) throws IOException {
        long currentPos = this.source.getPosition();
        COSObjectKey key = obj.getKey();
        COSBase parsedObj = this.parseObjectDynamically(key, false);
        if (parsedObj != null) {
            parsedObj.setDirect(false);
            parsedObj.setKey(key);
        }
        if (currentPos > 0L) {
            this.source.seek(currentPos);
        }
        return parsedObj;
    }

    @Override
    public RandomAccessReadView createRandomAccessReadView(long startPosition, long streamLength) throws IOException {
        return this.source.createView(startPosition, streamLength);
    }

    protected synchronized COSBase parseObjectDynamically(COSObjectKey objKey, boolean requireExistingNotCompressedObj) throws IOException {
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (!pdfObject.isObjectNull()) {
            return pdfObject.getObject();
        }
        Long offsetOrObjstmObNr = this.getObjectOffset(objKey, requireExistingNotCompressedObj);
        COSBase referencedObject = null;
        if (offsetOrObjstmObNr != null) {
            referencedObject = offsetOrObjstmObNr > 0L ? this.parseFileObject(offsetOrObjstmObNr, objKey) : this.parseObjectStreamObject(-offsetOrObjstmObNr.longValue(), objKey);
        }
        if (referencedObject == null || referencedObject instanceof COSNull) {
            pdfObject.setToNull();
        }
        return referencedObject;
    }

    private Long getObjectOffset(COSObjectKey objKey, boolean requireExistingNotCompressedObj) throws IOException {
        Long offsetOrObjstmObNr = this.document.getXrefTable().get(objKey);
        if (offsetOrObjstmObNr == null && this.isLenient && (offsetOrObjstmObNr = this.getBruteForceParser().getBFCOSObjectOffsets().get(objKey)) != null) {
            LOG.debug((Object)("Set missing offset " + offsetOrObjstmObNr + " for object " + objKey));
            this.document.getXrefTable().put(objKey, offsetOrObjstmObNr);
        }
        if (requireExistingNotCompressedObj && (offsetOrObjstmObNr == null || offsetOrObjstmObNr <= 0L)) {
            throw new IOException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration());
        }
        return offsetOrObjstmObNr;
    }

    private COSBase parseFileObject(Long objOffset, COSObjectKey objKey) throws IOException {
        String endObjectKey;
        this.source.seek(objOffset.longValue());
        long readObjNr = this.readObjectNumber();
        int readObjGen = this.readGenerationNumber();
        this.readExpectedString(OBJ_MARKER, true);
        if (readObjNr != objKey.getNumber() || readObjGen != objKey.getGeneration()) {
            throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen + " at offset " + objOffset);
        }
        this.skipSpaces();
        COSBase parsedObject = this.parseDirObject();
        if (parsedObject != null) {
            parsedObject.setDirect(false);
            parsedObject.setKey(objKey);
        }
        if ((endObjectKey = this.readString()).equals("stream")) {
            COSStream stream;
            this.source.rewind(endObjectKey.getBytes(StandardCharsets.ISO_8859_1).length);
            if (parsedObject instanceof COSDictionary) {
                stream = this.parseCOSStream((COSDictionary)parsedObject);
                if (this.securityHandler != null) {
                    this.securityHandler.decryptStream(stream, objKey.getNumber(), objKey.getGeneration());
                }
            } else {
                throw new IOException("Stream not preceded by dictionary (offset: " + objOffset + ").");
            }
            parsedObject = stream;
            this.skipSpaces();
            endObjectKey = this.readLine();
            if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                endObjectKey = this.readLine();
            }
        } else if (this.securityHandler != null) {
            this.securityHandler.decrypt(parsedObject, objKey.getNumber(), objKey.getGeneration());
        }
        if (!endObjectKey.startsWith("endobj")) {
            if (this.isLenient) {
                LOG.warn((Object)("Object (" + readObjNr + ":" + readObjGen + ") at offset " + objOffset + " does not end with 'endobj' but with '" + endObjectKey + "'"));
            } else {
                throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + objOffset + " does not end with 'endobj' but with '" + endObjectKey + "'");
            }
        }
        return parsedObject;
    }

    protected COSBase parseObjectStreamObject(long objstmObjNr, COSObjectKey key) throws IOException {
        Map streamObjects = this.decompressedObjects.computeIfAbsent(objstmObjNr, n -> new HashMap());
        COSBase objectStreamObject = (COSBase)streamObjects.remove(key);
        if (objectStreamObject != null) {
            return objectStreamObject;
        }
        COSObjectKey objKey = this.getObjectKey(objstmObjNr, 0);
        COSBase objstmBaseObj = this.document.getObjectFromPool(objKey).getObject();
        if (objstmBaseObj instanceof COSStream) {
            try {
                PDFObjectStreamParser parser = new PDFObjectStreamParser((COSStream)objstmBaseObj, this.document);
                Map<COSObjectKey, COSBase> allStreamObjects = parser.parseAllObjects();
                objectStreamObject = allStreamObjects.remove(key);
                allStreamObjects.entrySet().stream().forEach(e -> {
                    COSBase cfr_ignored_0 = (COSBase)streamObjects.putIfAbsent(e.getKey(), e.getValue());
                });
            }
            catch (IOException ex) {
                if (this.isLenient) {
                    LOG.error((Object)("object stream " + objstmObjNr + " could not be parsed due to an exception"), (Throwable)ex);
                }
                throw ex;
            }
        }
        return objectStreamObject;
    }

    private COSNumber getLength(COSBase lengthBaseObj) throws IOException {
        if (lengthBaseObj == null) {
            return null;
        }
        if (lengthBaseObj instanceof COSNumber) {
            return (COSNumber)lengthBaseObj;
        }
        if (lengthBaseObj instanceof COSObject) {
            COSObject lengthObj = (COSObject)lengthBaseObj;
            COSBase length = lengthObj.getObject();
            if (length == null) {
                throw new IOException("Length object content was not read.");
            }
            if (COSNull.NULL == length) {
                LOG.warn((Object)("Length object (" + lengthObj.getKey() + ") not found"));
                return null;
            }
            if (length instanceof COSNumber) {
                return (COSNumber)length;
            }
            throw new IOException("Wrong type of referenced length object " + lengthObj + ": " + length.getClass().getSimpleName());
        }
        throw new IOException("Wrong type of length object: " + lengthBaseObj.getClass().getSimpleName());
    }

    protected COSStream parseCOSStream(COSDictionary dic) throws IOException {
        long streamLength;
        this.readString();
        this.skipWhiteSpaces();
        COSNumber streamLengthObj = this.getLength(dic.getItem(COSName.LENGTH));
        if (streamLengthObj == null) {
            if (this.isLenient) {
                LOG.warn((Object)("The stream doesn't provide any stream length, using fallback readUntilEnd, at offset " + this.source.getPosition()));
            } else {
                throw new IOException("Missing length for stream.");
            }
        }
        long streamStartPosition = this.source.getPosition();
        if (streamLengthObj != null && this.validateStreamLength(streamLengthObj.longValue())) {
            streamLength = streamLengthObj.longValue();
            this.source.seek(this.source.getPosition() + (long)streamLengthObj.intValue());
        } else {
            streamLength = this.readUntilEndStream(new EndstreamFilterStream());
            if (streamLengthObj == null || streamLengthObj.longValue() != streamLength) {
                dic.setLong(COSName.LENGTH, streamLength);
            }
        }
        String endStream = this.readString();
        if (endStream.equals("endobj") && this.isLenient) {
            LOG.warn((Object)("stream ends with 'endobj' instead of 'endstream' at offset " + this.source.getPosition()));
            this.source.rewind(ENDOBJ.length);
        } else if (endStream.length() > 9 && this.isLenient && endStream.startsWith("endstream")) {
            LOG.warn((Object)("stream ends with '" + endStream + "' instead of 'endstream' at offset " + this.source.getPosition()));
            this.source.rewind(endStream.substring(9).getBytes(StandardCharsets.ISO_8859_1).length);
        } else if (!endStream.equals("endstream")) {
            throw new IOException("Error reading stream, expected='endstream' actual='" + endStream + "' at offset " + this.source.getPosition());
        }
        return this.document.createCOSStream(dic, streamStartPosition, streamLength);
    }

    private long readUntilEndStream(EndstreamFilterStream out) throws IOException {
        int bufSize;
        int charMatchCount = 0;
        byte[] keyw = ENDSTREAM;
        int quickTestOffset = 5;
        while ((bufSize = this.source.read(this.strmBuf, charMatchCount, 2048 - charMatchCount)) > 0) {
            int contentBytes;
            int bIdx;
            int maxQuicktestIdx = (bufSize += charMatchCount) - 5;
            for (bIdx = charMatchCount; bIdx < bufSize; ++bIdx) {
                byte ch;
                int quickTestIdx = bIdx + 5;
                if (charMatchCount == 0 && quickTestIdx < maxQuicktestIdx && ((ch = this.strmBuf[quickTestIdx]) > 116 || ch < 97)) {
                    bIdx = quickTestIdx;
                    continue;
                }
                ch = this.strmBuf[bIdx];
                if (ch == keyw[charMatchCount]) {
                    if (++charMatchCount != keyw.length) continue;
                    ++bIdx;
                    break;
                }
                if (charMatchCount == 3 && ch == ENDOBJ[charMatchCount]) {
                    keyw = ENDOBJ;
                    ++charMatchCount;
                    continue;
                }
                charMatchCount = ch == 101 ? 1 : (ch == 110 && charMatchCount == 7 ? 2 : 0);
                keyw = ENDSTREAM;
            }
            if ((contentBytes = Math.max(0, bIdx - charMatchCount)) > 0) {
                out.filter(this.strmBuf, 0, contentBytes);
            }
            if (charMatchCount == keyw.length) {
                this.source.rewind(bufSize - contentBytes);
                break;
            }
            System.arraycopy(keyw, 0, this.strmBuf, 0, charMatchCount);
        }
        return out.calculateLength();
    }

    private boolean validateStreamLength(long streamLength) throws IOException {
        long originOffset = this.source.getPosition();
        if (streamLength == 0L) {
            LOG.debug((Object)("Suspicious stream length 0, stream position: " + originOffset));
            return false;
        }
        if (streamLength < 0L) {
            LOG.warn((Object)("Invalid stream length: " + streamLength + ", start position: " + originOffset));
            return false;
        }
        long expectedEndOfStream = originOffset + streamLength;
        if (expectedEndOfStream > this.fileLen) {
            LOG.warn((Object)("The end of the stream is out of range, using workaround to read the stream, stream start position: " + originOffset + ", length: " + streamLength + ", expected end position: " + expectedEndOfStream));
            return false;
        }
        this.source.seek(expectedEndOfStream);
        this.skipSpaces();
        boolean endStreamFound = this.isString(ENDSTREAM);
        this.source.seek(originOffset);
        if (!endStreamFound) {
            LOG.warn((Object)("The end of the stream doesn't point to the correct offset, using workaround to read the stream, stream start position: " + originOffset + ", length: " + streamLength + ", expected end position: " + expectedEndOfStream));
            return false;
        }
        return true;
    }

    private long checkXRefOffset(long startXRefOffset) throws IOException {
        if (!this.isLenient) {
            return startXRefOffset;
        }
        this.source.seek(startXRefOffset);
        this.skipSpaces();
        if (this.isString(XREF_TABLE)) {
            return startXRefOffset;
        }
        if (startXRefOffset > 0L) {
            if (this.checkXRefStreamOffset(startXRefOffset)) {
                return startXRefOffset;
            }
            return this.calculateXRefFixedOffset(startXRefOffset);
        }
        return -1L;
    }

    private boolean checkXRefStreamOffset(long startXRefOffset) throws IOException {
        if (!this.isLenient || startXRefOffset == 0L) {
            return true;
        }
        this.source.seek(startXRefOffset - 1L);
        int nextValue = this.source.read();
        if (COSParser.isWhitespace(nextValue)) {
            this.skipSpaces();
            if (this.isDigit()) {
                try {
                    this.readObjectNumber();
                    this.readGenerationNumber();
                    this.readExpectedString(OBJ_MARKER, true);
                    COSDictionary dict = this.parseCOSDictionary(false);
                    this.source.seek(startXRefOffset);
                    if ("XRef".equals(dict.getNameAsString(COSName.TYPE))) {
                        return true;
                    }
                }
                catch (IOException exception) {
                    LOG.debug((Object)("No Xref stream at given location " + startXRefOffset), (Throwable)exception);
                    this.source.seek(startXRefOffset);
                }
            }
        }
        return false;
    }

    private long calculateXRefFixedOffset(long objectOffset) throws IOException {
        if (objectOffset < 0L) {
            LOG.error((Object)("Invalid object offset " + objectOffset + " when searching for a xref table/stream"));
            return 0L;
        }
        long newOffset = this.getBruteForceParser().bfSearchForXRef(objectOffset);
        if (newOffset > -1L) {
            LOG.debug((Object)("Fixed reference for xref table/stream " + objectOffset + " -> " + newOffset));
            return newOffset;
        }
        LOG.error((Object)("Can't find the object xref table/stream at offset " + objectOffset));
        return 0L;
    }

    private boolean validateXrefOffsets(Map<COSObjectKey, Long> xrefOffset) throws IOException {
        if (xrefOffset == null) {
            return true;
        }
        HashMap<COSObjectKey, COSObjectKey> correctedKeys = new HashMap<COSObjectKey, COSObjectKey>();
        HashSet<COSObjectKey> validKeys = new HashSet<COSObjectKey>();
        for (Map.Entry<COSObjectKey, Long> objectEntry : xrefOffset.entrySet()) {
            COSObjectKey objectKey = objectEntry.getKey();
            Long objectOffset = objectEntry.getValue();
            if (objectOffset == null || objectOffset < 0L) continue;
            COSObjectKey foundObjectKey = this.findObjectKey(objectKey, objectOffset, xrefOffset);
            if (foundObjectKey == null) {
                LOG.debug((Object)("Stop checking xref offsets as at least one (" + objectKey + ") couldn't be dereferenced"));
                return false;
            }
            if (foundObjectKey != objectKey) {
                correctedKeys.put(objectKey, foundObjectKey);
                continue;
            }
            validKeys.add(objectKey);
        }
        HashMap correctedPointers = new HashMap();
        for (Map.Entry correctedKeyEntry : correctedKeys.entrySet()) {
            if (validKeys.contains(correctedKeyEntry.getValue())) continue;
            correctedPointers.put(correctedKeyEntry.getValue(), xrefOffset.get(correctedKeyEntry.getKey()));
        }
        correctedKeys.forEach((key, value) -> {
            Long cfr_ignored_0 = (Long)xrefOffset.remove(key);
        });
        xrefOffset.putAll(correctedPointers);
        return true;
    }

    private void checkXrefOffsets() throws IOException {
        Map<COSObjectKey, Long> bfCOSObjectKeyOffsets;
        Map<COSObjectKey, Long> xrefOffset = this.xrefTrailerResolver.getXrefTable();
        if (!this.validateXrefOffsets(xrefOffset) && !(bfCOSObjectKeyOffsets = this.getBruteForceParser().getBFCOSObjectOffsets()).isEmpty()) {
            LOG.debug((Object)"Replaced read xref table with the results of a brute force search");
            xrefOffset.clear();
            xrefOffset.putAll(bfCOSObjectKeyOffsets);
        }
    }

    private COSObjectKey findObjectKey(COSObjectKey objectKey, long offset, Map<COSObjectKey, Long> xrefOffset) throws IOException {
        if (offset < 6L) {
            return null;
        }
        try {
            this.source.seek(offset);
            this.skipWhiteSpaces();
            if (this.source.getPosition() == offset) {
                this.source.seek(offset - 1L);
                if (this.source.getPosition() < offset) {
                    if (!this.isDigit()) {
                        this.source.read();
                    } else {
                        int newGenNr;
                        long current = this.source.getPosition();
                        this.source.seek(--current);
                        while (this.isDigit()) {
                            this.source.seek(--current);
                        }
                        long newObjNr = this.readObjectNumber();
                        COSObjectKey newObjKey = new COSObjectKey(newObjNr, newGenNr = this.readGenerationNumber());
                        Long existingOffset = xrefOffset.get(newObjKey);
                        if (existingOffset != null && existingOffset > 0L && Math.abs(offset - existingOffset) < 10L) {
                            LOG.debug((Object)("Found the object " + newObjKey + " instead of " + objectKey + " at offset " + offset + " - ignoring"));
                            return null;
                        }
                        this.source.seek(offset);
                    }
                }
            }
            long foundObjectNumber = this.readObjectNumber();
            if (objectKey.getNumber() != foundObjectNumber) {
                LOG.warn((Object)("found wrong object number. expected [" + objectKey.getNumber() + "] found [" + foundObjectNumber + "]"));
                if (!this.isLenient) {
                    return null;
                }
                objectKey = new COSObjectKey(foundObjectNumber, objectKey.getGeneration());
            }
            int genNumber = this.readGenerationNumber();
            this.readExpectedString(OBJ_MARKER, true);
            if (genNumber == objectKey.getGeneration()) {
                return objectKey;
            }
            if (this.isLenient && genNumber > objectKey.getGeneration()) {
                return new COSObjectKey(objectKey.getNumber(), genNumber);
            }
        }
        catch (IOException exception) {
            LOG.debug((Object)("No valid object at given location " + offset + " - ignoring"), (Throwable)exception);
        }
        return null;
    }

    private BruteForceParser getBruteForceParser() throws IOException {
        if (this.bruteForceParser == null) {
            this.bruteForceParser = new BruteForceParser(this.source, this.document);
        }
        return this.bruteForceParser;
    }

    protected void checkPages(COSDictionary root) throws IOException {
        COSDictionary pages;
        if (this.trailerWasRebuild && (pages = root.getCOSDictionary(COSName.PAGES)) != null) {
            this.checkPagesDictionary(pages, new HashSet<COSObject>());
        }
        if (root.getCOSDictionary(COSName.PAGES) == null) {
            throw new IOException("Page tree root must be a dictionary");
        }
    }

    private int checkPagesDictionary(COSDictionary pagesDict, Set<COSObject> set) {
        COSArray kidsArray = pagesDict.getCOSArray(COSName.KIDS);
        int numberOfPages = 0;
        if (kidsArray != null) {
            List<? extends COSBase> kidsList = kidsArray.toList();
            for (COSBase cOSBase : kidsList) {
                if (!(cOSBase instanceof COSObject) || set.contains((COSObject)cOSBase)) {
                    kidsArray.remove(cOSBase);
                    continue;
                }
                COSObject kidObject = (COSObject)cOSBase;
                COSBase kidBaseobject = kidObject.getObject();
                if (kidBaseobject == null || kidBaseobject.equals(COSNull.NULL)) {
                    LOG.warn((Object)("Removed null object " + cOSBase + " from pages dictionary"));
                    kidsArray.remove(cOSBase);
                    continue;
                }
                if (!(kidBaseobject instanceof COSDictionary)) continue;
                COSDictionary kidDictionary = (COSDictionary)kidBaseobject;
                COSName type = kidDictionary.getCOSName(COSName.TYPE);
                if (COSName.PAGES.equals(type)) {
                    set.add(kidObject);
                    numberOfPages += this.checkPagesDictionary(kidDictionary, set);
                    continue;
                }
                if (!COSName.PAGE.equals(type)) continue;
                ++numberOfPages;
            }
        }
        pagesDict.setInt(COSName.COUNT, numberOfPages);
        return numberOfPages;
    }

    private long parseStartXref() throws IOException {
        long startXref = -1L;
        if (this.isString(STARTXREF)) {
            this.readString();
            this.skipSpaces();
            startXref = this.readLong();
        }
        return startXref;
    }

    private boolean isString(byte[] string) throws IOException {
        boolean bytesMatching = true;
        long originOffset = this.source.getPosition();
        for (byte c : string) {
            if (this.source.read() == c) continue;
            bytesMatching = false;
            break;
        }
        this.source.seek(originOffset);
        return bytesMatching;
    }

    protected boolean isString(char[] string) throws IOException {
        boolean bytesMatching = true;
        long originOffset = this.source.getPosition();
        for (char c : string) {
            if (this.source.read() == c) continue;
            bytesMatching = false;
            break;
        }
        this.source.seek(originOffset);
        return bytesMatching;
    }

    private boolean parseTrailer() throws IOException {
        long trailerOffset = this.source.getPosition();
        if (this.isLenient) {
            int nextCharacter = this.source.peek();
            while (nextCharacter != 116 && COSParser.isDigit(nextCharacter)) {
                if (this.source.getPosition() == trailerOffset) {
                    LOG.warn((Object)("Expected trailer object at offset " + trailerOffset + ", keep trying"));
                }
                this.readLine();
                nextCharacter = this.source.peek();
            }
        }
        if (this.source.peek() != 116) {
            return false;
        }
        long currentOffset = this.source.getPosition();
        String nextLine = this.readLine();
        if (!nextLine.trim().equals("trailer")) {
            if (nextLine.startsWith("trailer")) {
                int len = "trailer".length();
                this.source.seek(currentOffset + (long)len);
            } else {
                return false;
            }
        }
        this.skipSpaces();
        COSDictionary parsedTrailer = this.parseCOSDictionary(true);
        this.xrefTrailerResolver.setTrailer(parsedTrailer);
        this.skipSpaces();
        return true;
    }

    protected boolean parsePDFHeader() throws IOException {
        return this.parseHeader(PDF_HEADER, PDF_DEFAULT_VERSION);
    }

    protected boolean parseFDFHeader() throws IOException {
        return this.parseHeader(FDF_HEADER, FDF_DEFAULT_VERSION);
    }

    private boolean parseHeader(String headerMarker, String defaultVersion) throws IOException {
        String header = this.readLine();
        if (!header.contains(headerMarker)) {
            header = this.readLine();
            while (!(header.contains(headerMarker) || header.length() > 0 && Character.isDigit(header.charAt(0)))) {
                header = this.readLine();
            }
        }
        if (!header.contains(headerMarker)) {
            this.source.seek(0L);
            return false;
        }
        int headerStart = header.indexOf(headerMarker);
        if (headerStart > 0) {
            header = header.substring(headerStart);
        }
        if (header.startsWith(headerMarker) && !header.matches(headerMarker + "\\d.\\d")) {
            if (header.length() < headerMarker.length() + 3) {
                header = headerMarker + defaultVersion;
                LOG.debug((Object)("No version found, set to " + defaultVersion + " as default."));
            } else {
                String headerGarbage = header.substring(headerMarker.length() + 3) + "\n";
                header = header.substring(0, headerMarker.length() + 3);
                this.source.rewind(headerGarbage.getBytes(StandardCharsets.ISO_8859_1).length);
            }
        }
        float headerVersion = -1.0f;
        try {
            String[] headerParts = header.split("-");
            if (headerParts.length == 2) {
                headerVersion = Float.parseFloat(headerParts[1]);
            }
        }
        catch (NumberFormatException exception) {
            LOG.debug((Object)"Can't parse the header version.", (Throwable)exception);
        }
        if (headerVersion < 0.0f) {
            if (this.isLenient) {
                headerVersion = 1.7f;
            } else {
                throw new IOException("Error getting header version: " + header);
            }
        }
        this.document.setVersion(headerVersion);
        this.source.seek(0L);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        if (this.source.peek() != 120) {
            return false;
        }
        xref = this.readString();
        if (!xref.trim().equals("xref")) {
            return false;
        }
        str = this.readString();
        b = str.getBytes(StandardCharsets.ISO_8859_1);
        this.source.rewind(b.length);
        this.xrefTrailerResolver.nextXrefObj(startByteOffset, XrefTrailerResolver.XRefType.TABLE);
        if (str.startsWith("trailer")) {
            COSParser.LOG.warn((Object)"skipping empty xref table");
            return false;
        }
        do {
            if ((splitString = StringUtil.splitOnSpace(currentLine = this.readLine())).length != 2) {
                COSParser.LOG.warn((Object)("Unexpected XRefTable Entry: " + currentLine));
                return false;
            }
            try {
                currObjID = Long.parseLong(splitString[0]);
            }
            catch (NumberFormatException exception) {
                COSParser.LOG.warn((Object)("XRefTable: invalid ID for the first object: " + currentLine));
                return false;
            }
            count = 0;
            try {
                count = Integer.parseInt(splitString[1]);
            }
            catch (NumberFormatException exception) {
                COSParser.LOG.warn((Object)("XRefTable: invalid number of objects: " + currentLine));
                return false;
            }
            this.skipSpaces();
            for (i = 0; i < count && !this.source.isEOF() && !this.isEndOfName(this.source.peek()) && this.source.peek() != 116; ++i) {
                currentLine = this.readLine();
                splitString = StringUtil.splitOnSpace(currentLine);
                if (splitString.length < 3) {
                    COSParser.LOG.warn((Object)("invalid xref line: " + currentLine));
                    break;
                }
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        currOffset = Long.parseLong(splitString[0]);
                        if (currOffset <= 0L) ** GOTO lbl49
                        currGenID = Integer.parseInt(splitString[1]);
                        objKey = new COSObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException(e);
                    }
                } else if (!splitString[2].equals("f")) {
                    throw new IOException("Corrupt XRefTable Entry - ObjID:" + currObjID);
                }
lbl49:
                // 4 sources

                ++currObjID;
                this.skipSpaces();
            }
            this.skipSpaces();
        } while (this.isDigit());
        return true;
    }

    protected PDEncryption getEncryption() throws IOException {
        if (this.document == null) {
            throw new IOException("You must parse the document first before calling getEncryption()");
        }
        return this.encryption;
    }

    protected AccessPermission getAccessPermission() throws IOException {
        if (this.document == null) {
            throw new IOException("You must parse the document first before calling getAccessPermission()");
        }
        return this.accessPermission;
    }

    protected void prepareDecryption() throws IOException {
        if (this.encryption != null) {
            return;
        }
        COSDictionary encryptionDictionary = this.document.getEncryptionDictionary();
        if (encryptionDictionary == null) {
            return;
        }
        try {
            DecryptionMaterial decryptionMaterial;
            this.encryption = new PDEncryption(encryptionDictionary);
            if (this.keyStoreInputStream != null) {
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(this.keyStoreInputStream, this.password.toCharArray());
                decryptionMaterial = new PublicKeyDecryptionMaterial(ks, this.keyAlias, this.password);
            } else {
                decryptionMaterial = new StandardDecryptionMaterial(this.password);
            }
            this.securityHandler = this.encryption.getSecurityHandler();
            this.securityHandler.prepareForDecryption(this.encryption, this.document.getDocumentID(), decryptionMaterial);
            this.accessPermission = this.securityHandler.getCurrentAccessPermission();
        }
        catch (IOException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error (" + e.getClass().getSimpleName() + ") while creating security handler for decryption", e);
        }
        finally {
            if (this.keyStoreInputStream != null) {
                IOUtils.closeQuietly((Closeable)this.keyStoreInputStream);
            }
        }
    }
}

