/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.devservices;

import io.quarkus.deployment.dev.devservices.ContainerInfo;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

public record RunningContainer(ContainerInfo containerInfo, Map<String, String> env) {
    public Optional<Integer> getPortMapping(int port) {
        return Arrays.stream(this.containerInfo.exposedPorts()).filter(p -> p.privatePort() != null && p.privatePort() == port).map(ContainerInfo.ContainerPort::publicPort).findFirst();
    }

    public Optional<String> tryGetEnv(String ... keys) {
        for (String key : keys) {
            String value = this.env.get(key);
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

