/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.values;

import docking.DialogComponentProvider;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.values.AbstractValue;
import docking.widgets.values.GValuesMap;
import docking.widgets.values.ValuesMapParseException;
import docking.widgets.values.ValuesMapValidator;
import ghidra.util.HTMLUtilities;
import ghidra.util.MessageType;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ValuesMapDialog
extends DialogComponentProvider {
    private static final int MAX_MESSAGE_LINE_WIDTH = 60;
    private JPanel valuesPanel;
    private GValuesMap valuesMap;
    private boolean cancelled = false;
    private String message;

    public ValuesMapDialog(String title, String message) {
        this(title, message, new GValuesMap());
    }

    public ValuesMapDialog(String title, String message, GValuesMap valuesMap) {
        super(title);
        this.message = message;
        this.valuesMap = valuesMap;
        this.valuesPanel = this.buildValuesPanel();
        this.addWorkPanel(this.buildWorkPanel());
        for (AbstractValue<?> value : valuesMap.getValues()) {
            this.buildComponentsForValue(value);
        }
        this.setRememberSize(false);
        this.addOKButton();
        this.addCancelButton();
    }

    public AbstractValue<?> addValue(AbstractValue<?> value) {
        this.valuesMap.addValue(value);
        this.buildComponentsForValue(value);
        return value;
    }

    public void setValidator(ValuesMapValidator validator) {
        this.valuesMap.setValidator(validator);
    }

    public GValuesMap getValues() {
        if (this.cancelled) {
            return null;
        }
        return this.valuesMap;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    protected void okCallback() {
        try {
            this.valuesMap.updateFromComponents();
        }
        catch (ValuesMapParseException e) {
            this.setStatusText(e.getMessage(), MessageType.ERROR);
            return;
        }
        if (this.valuesMap.isValid(this)) {
            this.close();
        }
    }

    @Override
    protected void cancelCallback() {
        this.valuesMap.reset();
        this.cancelled = true;
        super.cancelCallback();
    }

    private JPanel buildValuesPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(4, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panel.getAccessibleContext().setAccessibleName("Values");
        return panel;
    }

    private JComponent buildWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        if (this.message != null) {
            String literalHTML = HTMLUtilities.toLiteralHTML((String)this.message, (int)60);
            GHtmlLabel label = new GHtmlLabel(literalHTML);
            label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            panel.add((Component)label, "North");
        }
        JScrollPane scroll = new JScrollPane(this.valuesPanel);
        scroll.setHorizontalScrollBarPolicy(31);
        panel.add((Component)scroll, "Center");
        panel.getAccessibleContext().setAccessibleName("Values Map");
        return panel;
    }

    private void buildComponentsForValue(AbstractValue<?> value) {
        this.valuesPanel.add(new JLabel(value.getName() + ":", 4));
        this.valuesPanel.add(value.getComponent());
        value.updateComponentFromValue();
    }
}

