/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.DockableComponent;
import docking.DockingDialog;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import generic.util.action.SystemKeyBindings;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowFocusInfoAction
extends DockingAction {
    static final Logger log = LogManager.getLogger(ShowFocusInfoAction.class);

    public ShowFocusInfoAction() {
        super("Show Focus Info", "DockingWindows");
        this.createSystemKeyBinding(SystemKeyBindings.FOCUS_INFO_KEY);
        this.setEnabled(true);
        DockingWindowManager.getHelpService().excludeFromHelp((Object)this);
    }

    @Override
    public void actionPerformed(ActionContext context) {
        ShowFocusInfoAction.printFocusInformation();
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    private static void printFocusInformation() {
        DockingWindowManager winMgr = DockingWindowManager.getActiveInstance();
        ComponentPlaceholder info = winMgr.getFocusedComponent();
        DockableComponent dockableComp = null;
        if (info != null) {
            dockableComp = info.getComponent();
        }
        log.info("====================================");
        log.info("Active Docking Window Manager: " + winMgr.getRootFrame().getTitle() + ": " + System.identityHashCode(winMgr.getRootFrame()));
        if (info != null) {
            log.info("Focused Docking Window: " + info.getTitle() + ": " + System.identityHashCode(dockableComp));
        } else {
            log.info("Focused Docking Window: null");
        }
        log.info("");
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        log.info("Active Java Window: " + ShowFocusInfoAction.printComp(kfm.getActiveWindow()));
        log.info("Focused Java Window: " + ShowFocusInfoAction.printComp(kfm.getFocusedWindow()));
        log.info("Focused Java Component: " + ShowFocusInfoAction.printComp(kfm.getFocusOwner()));
        Object mouseOverObject = DockingWindowManager.getMouseOverObject();
        if (mouseOverObject instanceof Component) {
            log.info("Mouse-over Object: " + ShowFocusInfoAction.printComp((Component)mouseOverObject));
            log.info("Focusable?: " + ((Component)mouseOverObject).isFocusable());
        }
        log.info("");
    }

    private static String printComp(Component printComponent) {
        if (printComponent == null) {
            return null;
        }
        if (printComponent instanceof JFrame) {
            JFrame frame = (JFrame)printComponent;
            return "Window (" + frame.getTitle() + "): " + System.identityHashCode(frame);
        }
        if (printComponent instanceof DockingDialog) {
            DockingDialog dockingDialog = (DockingDialog)printComponent;
            return "DockingDialog: " + dockingDialog.getTitle() + ": " + System.identityHashCode(printComponent);
        }
        if (printComponent instanceof JButton) {
            return "JButton: " + ((JButton)printComponent).getText() + ": " + System.identityHashCode(printComponent);
        }
        Object name = "";
        String componentName = printComponent.getName();
        if (componentName != null) {
            name = " - '" + componentName + "' ";
        }
        return printComponent.getClass().getName() + (String)name + ": " + System.identityHashCode(printComponent);
    }
}

