/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.GhidraDataConverter;
import java.math.BigInteger;

public class WrappedMemBuffer
implements MemBuffer {
    private final GhidraDataConverter converter;
    private final MemBuffer memBuffer;
    private int baseOffset;
    private Address address;
    private static final int DEFAULT_BUFSIZE = 0;
    private byte[] buffer;
    private int minOffset = 0;
    private int maxOffset = -1;

    public WrappedMemBuffer(MemBuffer buf, int baseOffset) throws AddressOutOfBoundsException {
        this(buf, 0, baseOffset);
    }

    public WrappedMemBuffer(MemBuffer buf, int bufferSize, int baseOffset) throws AddressOutOfBoundsException {
        this.memBuffer = buf;
        this.converter = GhidraDataConverter.getInstance(buf.isBigEndian());
        this.buffer = new byte[bufferSize];
        this.setBaseOffset(baseOffset);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    private void setBaseOffset(int offset) throws AddressOutOfBoundsException {
        this.address = this.memBuffer.getAddress().add(offset);
        this.baseOffset = offset;
        if (this.buffer.length > 0) {
            this.minOffset = 0;
            this.maxOffset = -1;
            this.maxOffset = this.memBuffer.getBytes(this.buffer, this.baseOffset) - 1;
        }
    }

    private int computeOffset(int offset) throws MemoryAccessException {
        int bufOffset = this.baseOffset + offset;
        if (offset > 0 && bufOffset < this.baseOffset) {
            throw new MemoryAccessException("Invalid WrappedMemBuffer, offset would wrap underlying memory buffer");
        }
        if (offset < 0 && bufOffset > this.baseOffset) {
            throw new MemoryAccessException("Invalid WrappedMemBuffer offset, offset would wrap underlying memory buffer");
        }
        return bufOffset;
    }

    @Override
    public byte getByte(int offset) throws MemoryAccessException {
        if (this.buffer.length == 0) {
            return this.memBuffer.getByte(this.computeOffset(offset));
        }
        if (offset >= this.minOffset && offset <= this.maxOffset) {
            return this.buffer[offset - this.minOffset];
        }
        this.fillBuffer(offset);
        return this.buffer[0];
    }

    @Override
    public int getBytes(byte[] b, int offset) {
        try {
            if (this.buffer.length > 0 && b.length <= this.buffer.length) {
                if (offset < this.minOffset || b.length + offset - 1 > this.maxOffset) {
                    this.fillBuffer(offset);
                }
                if (offset >= this.minOffset && b.length + offset - 1 <= this.maxOffset) {
                    System.arraycopy(this.buffer, offset - this.minOffset, b, 0, b.length);
                    return b.length;
                }
            }
            return this.memBuffer.getBytes(b, this.computeOffset(offset));
        }
        catch (MemoryAccessException e) {
            return 0;
        }
    }

    private void fillBuffer(int offset) throws MemoryAccessException {
        int nRead = this.memBuffer.getBytes(this.buffer, this.computeOffset(offset));
        if (nRead == 0) {
            throw new MemoryAccessException("No bytes available in memory to cache");
        }
        this.minOffset = offset;
        this.maxOffset = offset + nRead - 1;
    }

    @Override
    public Memory getMemory() {
        return this.memBuffer.getMemory();
    }

    @Override
    public boolean isBigEndian() {
        return this.memBuffer.isBigEndian();
    }

    @Override
    public short getShort(int offset) throws MemoryAccessException {
        return this.converter.getShort(this, offset);
    }

    @Override
    public int getInt(int offset) throws MemoryAccessException {
        return this.converter.getInt(this, offset);
    }

    @Override
    public long getLong(int offset) throws MemoryAccessException {
        return this.converter.getLong(this, offset);
    }

    @Override
    public BigInteger getBigInteger(int offset, int size, boolean signed) throws MemoryAccessException {
        return this.converter.getBigInteger(this, offset, size, signed);
    }
}

