/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AbstractPointerTypedefBuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.PointerTypeSettingsDefinition;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.util.classfinder.ClassTranslator;

public class IBO64DataType
extends AbstractPointerTypedefBuiltIn {
    public static final IBO64DataType dataType = new IBO64DataType();
    static final String NAME = "ImageBaseOffset64";
    private static TypeDefSettingsDefinition[] IBO_TYPEDEF_SETTINGS_DEFS = new TypeDefSettingsDefinition[]{PointerTypeSettingsDefinition.DEF};

    public IBO64DataType() {
        this(null);
    }

    public IBO64DataType(DataTypeManager dtm) {
        super(NAME, null, 8, dtm);
        PointerTypeSettingsDefinition.DEF.setType(this.getDefaultSettings(), PointerType.IMAGE_BASE_RELATIVE);
    }

    @Override
    public String getDescription() {
        return "64-bit Image Base Offset Relative Pointer-Typedef";
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (this.dataMgr == dtm) {
            return this;
        }
        return new IBO64DataType(dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "ibo64";
    }

    public TypeDefSettingsDefinition[] getBuiltInSettingsDefinitions() {
        return IBO_TYPEDEF_SETTINGS_DEFS;
    }

    public static PointerTypedef createIBO64PointerTypedef(DataType referencedDataType) {
        return new PointerTypedef(null, referencedDataType, 8, referencedDataType != null ? referencedDataType.getDataTypeManager() : null, PointerType.IMAGE_BASE_RELATIVE);
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.ImageBaseOffset64", (String)IBO64DataType.class.getName());
        ClassTranslator.put((String)"ghidra.program.model.data.ImageBaseOffset64DataType", (String)IBO64DataType.class.getName());
    }
}

