/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.bookmark.OldBookmark;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.properties.IntPropertyMapDB;
import ghidra.program.database.properties.LongPropertyMapDB;
import ghidra.program.database.properties.ObjectPropertyMapDB;
import ghidra.program.database.properties.PropertiesDBAdapter;
import ghidra.program.database.properties.PropertiesDBAdapterV0;
import ghidra.program.database.properties.PropertyMapDB;
import ghidra.program.database.properties.StringPropertyMapDB;
import ghidra.program.database.properties.UnsupportedMapDB;
import ghidra.program.database.properties.VoidPropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.LongPropertyMap;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.model.util.VoidPropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.program.util.ProgramEvent;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.Saveable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.map.TypeMismatchException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class DBPropertyMapManager
implements PropertyMapManager,
ManagerDB {
    private DBHandle dbHandle;
    private ProgramDB program;
    private AddressMap addrMap;
    private ChangeManager changeMgr;
    private PropertiesDBAdapter propertiesDBAdapter;
    private ConcurrentHashMap<String, PropertyMapDB<?>> propertyMapCache;
    private Lock lock;
    static final int CURRENT_PROPERTIES_TABLE_VERSION = 0;
    static final String PROPERTIES_TABLE_NAME = "Properties";
    static final int PROPERTY_TYPE_COL = 0;
    static final int OBJECT_CLASS_COL = 1;
    static final byte INT_PROPERTY_TYPE = 0;
    static final byte LONG_PROPERTY_TYPE = 1;
    static final byte STRING_PROPERTY_TYPE = 2;
    static final byte VOID_PROPERTY_TYPE = 3;
    static final byte OBJECT_PROPERTY_TYPE = 4;
    static final Schema PROPERTIES_SCHEMA = new Schema(0, (Field)StringField.INSTANCE, "Name", new Field[]{ByteField.INSTANCE, StringField.INSTANCE, IntField.INSTANCE}, new String[]{"Type", "Object Class", "Version"});

    public DBPropertyMapManager(DBHandle handle, ChangeManager changeMgr, AddressMap addrMap, OpenMode openMode, Lock lock, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        this.dbHandle = handle;
        this.changeMgr = changeMgr;
        this.addrMap = addrMap;
        this.lock = lock;
        if (openMode == OpenMode.CREATE) {
            this.dbHandle.createTable(PROPERTIES_TABLE_NAME, PROPERTIES_SCHEMA);
        }
        this.findAdapters(handle);
        this.propertyMapCache = new ConcurrentHashMap();
        this.loadPropertyMaps(openMode, monitor);
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
    }

    @Override
    public void programReady(OpenMode openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
        this.lock.acquire();
        try {
            for (PropertyMapDB<?> map : this.propertyMapCache.values()) {
                map.invalidate();
            }
            this.loadPropertyMaps(null, TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
        }
        catch (VersionException e) {
            throw new AssertException();
        }
        finally {
            this.lock.release();
        }
    }

    private void loadPropertyMaps(OpenMode openMode, TaskMonitor monitor) throws VersionException, CancelledException {
        try {
            VersionException ve = null;
            HashSet oldMapNames = new HashSet(this.propertyMapCache.keySet());
            RecordIterator iter = this.propertiesDBAdapter.getRecords();
            while (iter.hasNext()) {
                DBRecord rec = iter.next();
                byte propertyType = rec.getByteValue(0);
                String name = rec.getKeyField().getString();
                oldMapNames.remove(name);
                PropertyMapDB pm = this.propertyMapCache.get(name);
                if (pm != null) {
                    if (pm.validate(this.lock)) continue;
                    this.propertyMapCache.remove(name);
                }
                try {
                    switch (propertyType) {
                        case 0: {
                            pm = new IntPropertyMapDB(this.dbHandle, openMode, (ErrorHandler)this.program, this.changeMgr, this.addrMap, name, monitor);
                            break;
                        }
                        case 1: {
                            pm = new LongPropertyMapDB(this.dbHandle, openMode, (ErrorHandler)this.program, this.changeMgr, this.addrMap, name, monitor);
                            break;
                        }
                        case 2: {
                            pm = new StringPropertyMapDB(this.dbHandle, openMode, (ErrorHandler)this.program, this.changeMgr, this.addrMap, name, monitor);
                            break;
                        }
                        case 3: {
                            pm = new VoidPropertyMapDB(this.dbHandle, openMode, (ErrorHandler)this.program, this.changeMgr, this.addrMap, name, monitor);
                            break;
                        }
                        case 4: {
                            String className = rec.getString(1);
                            if ("ghidra.app.plugin.bookmark.BookmarkInfo".equals(className) || "ghidra.program.util.Bookmark".equals(className)) {
                                if (openMode == OpenMode.UPDATE) {
                                    throw new VersionException(1, true);
                                }
                                pm = new ObjectPropertyMapDB<OldBookmark>(this.dbHandle, openMode, (ErrorHandler)this.program, this.changeMgr, this.addrMap, name, OldBookmark.class, monitor, false);
                                break;
                            }
                            pm = new ObjectPropertyMapDB<Saveable>(this.dbHandle, openMode, (ErrorHandler)this.program, this.changeMgr, this.addrMap, name, ObjectPropertyMapDB.getSaveableClassForName(className), monitor, false);
                            break;
                        }
                        default: {
                            if (openMode != null) {
                                Msg.showError((Object)this, null, (String)"Unsupported Property", (Object)("WARNING:  property ignored, unrecognized type: " + propertyType));
                            }
                            break;
                        }
                    }
                }
                catch (VersionException e) {
                    ve = e.combine(ve);
                }
                if (pm == null) {
                    pm = new UnsupportedMapDB(this.dbHandle, openMode, (ErrorHandler)this.program, this.changeMgr, this.addrMap, name, monitor);
                }
                this.propertyMapCache.put(name, pm);
            }
            for (String obsoleteMapName : oldMapNames) {
                this.propertyMapCache.remove(obsoleteMapName);
            }
            if (ve != null) {
                throw ve;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
    }

    private void findAdapters(DBHandle handle) throws VersionException {
        this.propertiesDBAdapter = new PropertiesDBAdapterV0(this.dbHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntPropertyMap createIntPropertyMap(String propertyName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            if (this.propertyMapCache.containsKey(propertyName)) {
                throw new DuplicateNameException();
            }
            IntPropertyMapDB pm = null;
            try {
                pm = new IntPropertyMapDB(this.dbHandle, OpenMode.CREATE, (ErrorHandler)this.program, this.changeMgr, this.addrMap, propertyName, TaskMonitor.DUMMY);
                this.propertiesDBAdapter.putRecord(propertyName, (byte)0, null);
                this.propertyMapCache.put(propertyName, pm);
            }
            catch (VersionException e) {
                throw new AssertException();
            }
            catch (CancelledException e) {
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            IntPropertyMapDB intPropertyMapDB = pm;
            return intPropertyMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongPropertyMap createLongPropertyMap(String propertyName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            if (this.propertyMapCache.containsKey(propertyName)) {
                throw new DuplicateNameException();
            }
            LongPropertyMapDB pm = null;
            try {
                pm = new LongPropertyMapDB(this.dbHandle, OpenMode.CREATE, (ErrorHandler)this.program, this.changeMgr, this.addrMap, propertyName, TaskMonitor.DUMMY);
                this.propertiesDBAdapter.putRecord(propertyName, (byte)1, null);
                this.propertyMapCache.put(propertyName, pm);
            }
            catch (VersionException e) {
                throw new AssertException();
            }
            catch (CancelledException e) {
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            LongPropertyMapDB longPropertyMapDB = pm;
            return longPropertyMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringPropertyMap createStringPropertyMap(String propertyName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            if (this.propertyMapCache.containsKey(propertyName)) {
                throw new DuplicateNameException();
            }
            StringPropertyMapDB pm = null;
            try {
                pm = new StringPropertyMapDB(this.dbHandle, OpenMode.CREATE, (ErrorHandler)this.program, this.changeMgr, this.addrMap, propertyName, TaskMonitor.DUMMY);
                this.propertiesDBAdapter.putRecord(propertyName, (byte)2, null);
                this.propertyMapCache.put(propertyName, pm);
            }
            catch (VersionException e) {
                throw new AssertException();
            }
            catch (CancelledException e) {
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            StringPropertyMapDB stringPropertyMapDB = pm;
            return stringPropertyMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Saveable> ObjectPropertyMap<T> createObjectPropertyMap(String propertyName, Class<T> objectClass) throws DuplicateNameException {
        this.lock.acquire();
        try {
            if (this.propertyMapCache.containsKey(propertyName)) {
                throw new DuplicateNameException();
            }
            ObjectPropertyMapDB<T> pm = null;
            try {
                pm = new ObjectPropertyMapDB<T>(this.dbHandle, OpenMode.CREATE, (ErrorHandler)this.program, this.changeMgr, this.addrMap, propertyName, objectClass, TaskMonitor.DUMMY, false);
                this.propertiesDBAdapter.putRecord(propertyName, (byte)4, objectClass.getName());
                this.propertyMapCache.put(propertyName, pm);
            }
            catch (VersionException e) {
                throw new AssertException();
            }
            catch (CancelledException e) {
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            ObjectPropertyMapDB<T> objectPropertyMapDB = pm;
            return objectPropertyMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VoidPropertyMap createVoidPropertyMap(String propertyName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            if (this.propertyMapCache.containsKey(propertyName)) {
                throw new DuplicateNameException();
            }
            VoidPropertyMapDB pm = null;
            try {
                pm = new VoidPropertyMapDB(this.dbHandle, OpenMode.CREATE, (ErrorHandler)this.program, this.changeMgr, this.addrMap, propertyName, TaskMonitor.DUMMY);
                this.propertiesDBAdapter.putRecord(propertyName, (byte)3, null);
                this.propertyMapCache.put(propertyName, pm);
            }
            catch (VersionException e) {
                throw new AssertException();
            }
            catch (CancelledException e) {
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            VoidPropertyMapDB voidPropertyMapDB = pm;
            return voidPropertyMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public PropertyMap<?> getPropertyMap(String propertyName) {
        return this.propertyMapCache.get(propertyName);
    }

    @Override
    public IntPropertyMap getIntPropertyMap(String propertyName) {
        PropertyMapDB<?> pm = this.propertyMapCache.get(propertyName);
        if (pm == null || pm instanceof IntPropertyMap) {
            return (IntPropertyMap)((Object)pm);
        }
        throw new TypeMismatchException("Property " + propertyName + " is not int type");
    }

    @Override
    public LongPropertyMap getLongPropertyMap(String propertyName) {
        PropertyMapDB<?> pm = this.propertyMapCache.get(propertyName);
        if (pm == null || pm instanceof LongPropertyMap) {
            return (LongPropertyMap)((Object)pm);
        }
        throw new TypeMismatchException("Property " + propertyName + " is not long type");
    }

    @Override
    public StringPropertyMap getStringPropertyMap(String propertyName) {
        PropertyMapDB<?> pm = this.propertyMapCache.get(propertyName);
        if (pm == null || pm instanceof StringPropertyMap) {
            return (StringPropertyMap)((Object)pm);
        }
        throw new TypeMismatchException("Property " + propertyName + " is not String type");
    }

    public ObjectPropertyMap<?> getObjectPropertyMap(String propertyName) {
        PropertyMapDB<?> pm = this.propertyMapCache.get(propertyName);
        if (pm == null || pm instanceof ObjectPropertyMap) {
            return (ObjectPropertyMap)((Object)pm);
        }
        throw new TypeMismatchException("Property " + propertyName + " is not object type");
    }

    @Override
    public VoidPropertyMap getVoidPropertyMap(String propertyName) {
        PropertyMapDB<?> pm = this.propertyMapCache.get(propertyName);
        if (pm == null || pm instanceof VoidPropertyMap) {
            return (VoidPropertyMap)((Object)pm);
        }
        throw new TypeMismatchException("Property " + propertyName + " is not Void type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePropertyMap(String propertyName) {
        this.lock.acquire();
        try {
            PropertyMapDB<?> pm = this.propertyMapCache.remove(propertyName);
            if (pm != null) {
                pm.delete();
                this.propertiesDBAdapter.removeRecord(propertyName);
                this.propertyMapCache.remove(propertyName);
                this.changeMgr.setObjChanged(ProgramEvent.CODE_UNIT_PROPERTY_ALL_REMOVED, propertyName, null, null);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    @Override
    public Iterator<String> propertyManagers() {
        this.lock.acquire();
        try {
            Iterator<String> iterator = this.propertyMapCache.keySet().stream().sorted().iterator();
            return iterator;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Address addr) {
        this.lock.acquire();
        try {
            for (PropertyMapDB<?> pm : this.propertyMapCache.values()) {
                pm.remove(addr);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        AddressRange.checkValidRange(startAddr, endAddr);
        this.lock.acquire();
        try {
            for (PropertyMapDB<?> pm : this.propertyMapCache.values()) {
                monitor.checkCancelled();
                pm.removeRange(startAddr, endAddr);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            for (PropertyMapDB<?> pm : this.propertyMapCache.values()) {
                monitor.checkCancelled();
                pm.moveRange(fromAddr, fromAddr.add(length - 1L), toAddr);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        this.removeAll(startAddr, endAddr, monitor);
    }
}

