/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyState;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyStateGenerator;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructState;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyGeneratedPrototype;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseBranch;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseHiddenNode;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseTreeNode;
import ghidra.app.plugin.assembler.sleigh.util.AsmUtil;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class AssemblyConstructStateGenerator
extends AbstractAssemblyStateGenerator<AssemblyParseBranch> {
    public AssemblyConstructStateGenerator(AbstractAssemblyTreeResolver<?> resolver, AssemblyParseBranch node, AssemblyResolvedPatterns fromLeft) {
        super(resolver, node, fromLeft);
    }

    @Override
    public Stream<AssemblyGeneratedPrototype> generate(AbstractAssemblyStateGenerator.GeneratorContext gc) {
        AssemblyProduction production = ((AssemblyParseBranch)this.node).getProduction();
        return this.resolver.grammar.getSemantics(production).stream().flatMap(sem -> this.applyConstructor(gc, (AssemblyConstructorSemantic)sem));
    }

    protected List<AssemblyParseTreeNode> orderOpNodes(AssemblyConstructorSemantic sem) {
        Constructor cons = sem.getConstructor();
        Object[] arr = new AssemblyParseTreeNode[cons.getNumOperands()];
        List<AssemblyParseTreeNode> result = Arrays.asList(arr);
        Arrays.fill(arr, new AssemblyParseHiddenNode(this.resolver.grammar));
        int index = 0;
        AssemblyProduction production = ((AssemblyParseBranch)this.node).getProduction();
        List<AssemblyParseTreeNode> substitutions = ((AssemblyParseBranch)this.node).getSubstitutions();
        for (int i = 0; i < production.getRHS().size(); ++i) {
            AssemblySymbol sym = production.getRHS().getSymbol(i);
            if (!sym.takesOperandIndex()) continue;
            result.set(sem.getOperandIndex(index), substitutions.get(i));
            ++index;
        }
        return result;
    }

    protected Stream<AssemblyGeneratedPrototype> applyConstructor(AbstractAssemblyStateGenerator.GeneratorContext gc, AssemblyConstructorSemantic sem) {
        Stream<AssemblyResolvedPatterns> applied = sem.applyPatternsForward(gc.shift, this.fromLeft).filter(pat -> {
            if (pat == null) {
                gc.dbg("Conflicting pattern. fromLeft=" + String.valueOf(this.fromLeft) + ",sem=" + sem.getLocation());
                return false;
            }
            return true;
        }).map(pat -> sem.applyContextChangesForward(this.resolver.vals, (AssemblyResolvedPatterns)pat));
        List<AssemblyParseTreeNode> opOrdered = this.orderOpNodes(sem);
        return applied.flatMap(patterned -> this.applyOperands(gc, (AssemblyResolvedPatterns)patterned, sem, opOrdered));
    }

    protected Stream<AssemblyGeneratedPrototype> applyOperands(AbstractAssemblyStateGenerator.GeneratorContext gc, AssemblyResolvedPatterns fromMutations, AssemblyConstructorSemantic sem, List<AssemblyParseTreeNode> opOrdered) {
        Constructor cons = sem.getConstructor();
        List<AbstractAssemblyStateGenerator.GeneratorContext> siblingGcs = Arrays.asList(new AbstractAssemblyStateGenerator.GeneratorContext[cons.getNumOperands()]);
        return this.applyRemainingOperands(gc, siblingGcs, fromMutations, sem, opOrdered, List.of());
    }

    protected Stream<AssemblyGeneratedPrototype> applyRemainingOperands(AbstractAssemblyStateGenerator.GeneratorContext parentGc, List<AbstractAssemblyStateGenerator.GeneratorContext> childGcs, AssemblyResolvedPatterns fromLeft, AssemblyConstructorSemantic sem, List<AssemblyParseTreeNode> opOrdered, List<AbstractAssemblyState> children) {
        Constructor cons = sem.getConstructor();
        int opIdx = children.size();
        if (opIdx == cons.getNumOperands()) {
            return Stream.of(new AssemblyGeneratedPrototype(new AssemblyConstructState(this.resolver, parentGc.path, parentGc.shift, sem, children), fromLeft));
        }
        AssemblyParseTreeNode opNode = opOrdered.get(opIdx);
        OperandSymbol opSym = cons.getOperand(opIdx);
        int offset = opSym.getRelativeOffset();
        int offsetBase = opSym.getOffsetBase();
        if (-1 != offsetBase) {
            int baseShift = childGcs.get((int)offsetBase).shift;
            int baseLength = children.get(offsetBase).getLength();
            offset += baseShift - parentGc.shift + baseLength;
        }
        AbstractAssemblyStateGenerator<?> opGen = this.resolver.getStateGenerator(opSym, opNode, fromLeft);
        AbstractAssemblyStateGenerator.GeneratorContext opGc = parentGc.push(sem, offset);
        childGcs.set(opIdx, opGc);
        return opGen.generate(opGc).flatMap(prot -> this.applyRemainingOperands(parentGc, new ArrayList<AbstractAssemblyStateGenerator.GeneratorContext>(childGcs), prot.patterns, sem, opOrdered, AsmUtil.extendList(children, prot.state)));
    }
}

