/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.SecurityHelper;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.cert.Certificate;
import java.util.Enumeration;

public class DocumentJarClassLoader
extends URLClassLoader {
    protected CodeSource documentCodeSource = null;

    public DocumentJarClassLoader(URL jarURL, URL documentURL) {
        super(new URL[]{jarURL});
        if (documentURL != null) {
            this.documentCodeSource = new CodeSource(documentURL, (Certificate[])null);
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection pc = SecurityHelper.getInstance().getPermissions(codesource);
        if (this.documentCodeSource != null) {
            PermissionCollection urlPC = super.getPermissions(this.documentCodeSource);
            if (pc != null) {
                Enumeration<Permission> items = urlPC.elements();
                while (items.hasMoreElements()) {
                    pc.add(items.nextElement());
                }
            } else {
                pc = urlPC;
            }
        } else if (pc == null) {
            pc = new Permissions();
        }
        return pc;
    }
}

