/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.List;
import java.util.Random;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Force;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.util.test.FreeColTestCase;

public class REFTest
extends FreeColTestCase {
    private static final UnitType artilleryType = REFTest.spec().getUnitType("model.unit.artillery");
    private static final UnitType soldierType = REFTest.spec().getUnitType("model.unit.kingsRegular");

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    public void testCreateREFPlayer() {
        ServerGame game = ServerTestHelper.startServerGame(REFTest.getTestMap());
        Specification spec = game.getSpecification();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer player1 = this.getServerPlayer(game, "model.nation.dutch");
        Force exf = player1.getMonarch().getExpeditionaryForce();
        exf.prepareToBoard(null);
        List<AbstractUnit> refBeforeIndependence = exf.getUnitList();
        ServerPlayer refPlayer = igc.createREFPlayer(player1);
        REFTest.assertNotNull((String)"REF player is null", (Object)refPlayer);
        REFTest.assertNotNull((String)"Player ref is null", (Object)player1.getREFPlayer());
        REFTest.assertEquals((String)"REF player should be player1 ref", (Object)refPlayer, (Object)player1.getREFPlayer());
        Force newf = new Force(spec);
        for (Unit u : refPlayer.getUnitSet()) {
            newf.add(new AbstractUnit(u.getType(), u.getRole().getId(), 1));
        }
        REFTest.assertTrue((String)"REF player force != Player monarch Expeditionary force", (boolean)exf.matchAll(newf));
    }

    public void testAddToREF() {
        ServerGame game = ServerTestHelper.startServerGame(REFTest.getTestMap());
        Specification spec = game.getSpecification();
        InGameController igc = ServerTestHelper.getInGameController();
        Random random = ServerTestHelper.getServer().getServerRandom();
        ServerPlayer player1 = this.getServerPlayer(game, "model.nation.dutch");
        Monarch monarch = player1.getMonarch();
        game.setTurn(new Turn(200));
        REFTest.assertTrue((String)"REF addition", (boolean)monarch.actionIsValid(Monarch.MonarchAction.ADD_TO_REF));
        Force exf = monarch.getExpeditionaryForce();
        int done = 0;
        while (done != 3) {
            boolean naval = monarch.shouldAddNavalUnit();
            AbstractUnit au = monarch.addToREF(random);
            REFTest.assertNotNull((String)"REF add", (Object)au);
            if (naval) {
                REFTest.assertTrue((String)"Naval unit required", (boolean)au.getType(spec).isNaval());
            } else {
                REFTest.assertFalse((String)"Land unit required", (boolean)au.getType(spec).isNaval());
            }
            if (au.getType(spec).isNaval()) {
                done |= 2;
                continue;
            }
            done |= 1;
        }
    }
}

