/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jacoco.core.runtime.AgentOptions;
import org.jacoco.core.tools.ExecDumpClient;
import org.jacoco.core.tools.ExecFileLoader;

public class DumpTask
extends Task {
    private boolean dump = true;
    private boolean reset = false;
    private File destfile = null;
    private String address = AgentOptions.DEFAULT_ADDRESS;
    private int port = 6300;
    private int retryCount = 10;
    private boolean append = true;

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public void execute() throws BuildException {
        if (this.port <= 0) {
            throw new BuildException("Invalid port value", this.getLocation());
        }
        if (this.dump && this.destfile == null) {
            throw new BuildException("Destination file is required when dumping execution data", this.getLocation());
        }
        ExecDumpClient client = new ExecDumpClient(){

            protected void onConnecting(InetAddress address, int port) {
                DumpTask.this.log(String.format("Connecting to %s:%s", address, port));
            }

            protected void onConnectionFailure(IOException exception) {
                DumpTask.this.log(exception.getMessage());
            }
        };
        client.setDump(this.dump);
        client.setReset(this.reset);
        client.setRetryCount(this.retryCount);
        try {
            ExecFileLoader loader = client.dump(this.address, this.port);
            if (this.dump) {
                this.log(String.format("Dumping execution data to %s", this.destfile.getAbsolutePath()));
                loader.save(this.destfile, this.append);
            }
        }
        catch (IOException e) {
            throw new BuildException("Unable to dump coverage data", (Throwable)e, this.getLocation());
        }
    }
}

