﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/states/SFN_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SFN {
namespace Model {
class CreateStateMachineResult {
 public:
  AWS_SFN_API CreateStateMachineResult() = default;
  AWS_SFN_API CreateStateMachineResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SFN_API CreateStateMachineResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) that identifies the created state machine.</p>
   */
  inline const Aws::String& GetStateMachineArn() const { return m_stateMachineArn; }
  template <typename StateMachineArnT = Aws::String>
  void SetStateMachineArn(StateMachineArnT&& value) {
    m_stateMachineArnHasBeenSet = true;
    m_stateMachineArn = std::forward<StateMachineArnT>(value);
  }
  template <typename StateMachineArnT = Aws::String>
  CreateStateMachineResult& WithStateMachineArn(StateMachineArnT&& value) {
    SetStateMachineArn(std::forward<StateMachineArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date the state machine is created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDate() const { return m_creationDate; }
  template <typename CreationDateT = Aws::Utils::DateTime>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::Utils::DateTime>
  CreateStateMachineResult& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) that identifies the created state machine
   * version. If you do not set the <code>publish</code> parameter to
   * <code>true</code>, this field returns null value.</p>
   */
  inline const Aws::String& GetStateMachineVersionArn() const { return m_stateMachineVersionArn; }
  template <typename StateMachineVersionArnT = Aws::String>
  void SetStateMachineVersionArn(StateMachineVersionArnT&& value) {
    m_stateMachineVersionArnHasBeenSet = true;
    m_stateMachineVersionArn = std::forward<StateMachineVersionArnT>(value);
  }
  template <typename StateMachineVersionArnT = Aws::String>
  CreateStateMachineResult& WithStateMachineVersionArn(StateMachineVersionArnT&& value) {
    SetStateMachineVersionArn(std::forward<StateMachineVersionArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateStateMachineResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_stateMachineArn;

  Aws::Utils::DateTime m_creationDate{};

  Aws::String m_stateMachineVersionArn;

  Aws::String m_requestId;
  bool m_stateMachineArnHasBeenSet = false;
  bool m_creationDateHasBeenSet = false;
  bool m_stateMachineVersionArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SFN
}  // namespace Aws
