/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright (C) 2024 Igor Belwon <igor.belwon@mentallysanemainliners.org>
 *
 * Device Tree binding constants for Exynos990 clock controller.
 */

#ifndef _DT_BINDINGS_CLOCK_EXYNOS_990_H
#define _DT_BINDINGS_CLOCK_EXYNOS_990_H

/* CMU_TOP */
#define CLK_FOUT_SHARED0_PLL		1
#define CLK_FOUT_SHARED1_PLL		2
#define CLK_FOUT_SHARED2_PLL		3
#define CLK_FOUT_SHARED3_PLL		4
#define CLK_FOUT_SHARED4_PLL		5
#define CLK_FOUT_G3D_PLL		6
#define CLK_FOUT_MMC_PLL		7
#define CLK_MOUT_PLL_SHARED0		8
#define CLK_MOUT_PLL_SHARED1		9
#define CLK_MOUT_PLL_SHARED2		10
#define CLK_MOUT_PLL_SHARED3		11
#define CLK_MOUT_PLL_SHARED4		12
#define CLK_MOUT_PLL_MMC		13
#define CLK_MOUT_PLL_G3D		14
#define CLK_MOUT_CMU_APM_BUS		15
#define CLK_MOUT_CMU_AUD_CPU		16
#define CLK_MOUT_CMU_BUS0_BUS		17
#define CLK_MOUT_CMU_BUS1_BUS		18
#define CLK_MOUT_CMU_BUS1_SSS		19
#define CLK_MOUT_CMU_CIS_CLK0		20
#define CLK_MOUT_CMU_CIS_CLK1		21
#define CLK_MOUT_CMU_CIS_CLK2		22
#define CLK_MOUT_CMU_CIS_CLK3		23
#define CLK_MOUT_CMU_CIS_CLK4		24
#define CLK_MOUT_CMU_CIS_CLK5		25
#define CLK_MOUT_CMU_CMU_BOOST		26
#define CLK_MOUT_CMU_CORE_BUS		27
#define CLK_MOUT_CMU_CPUCL0_DBG_BUS	28
#define CLK_MOUT_CMU_CPUCL0_SWITCH	29
#define CLK_MOUT_CMU_CPUCL1_SWITCH	30
#define CLK_MOUT_CMU_CPUCL2_BUSP	31
#define CLK_MOUT_CMU_CPUCL2_SWITCH	32
#define CLK_MOUT_CMU_CSIS_BUS		33
#define CLK_MOUT_CMU_CSIS_OIS_MCU	34
#define CLK_MOUT_CMU_DNC_BUS		35
#define CLK_MOUT_CMU_DNC_BUSM		36
#define CLK_MOUT_CMU_DNS_BUS		37
#define CLK_MOUT_CMU_DPU		38
#define CLK_MOUT_CMU_DPU_ALT		39
#define CLK_MOUT_CMU_DSP_BUS		40
#define CLK_MOUT_CMU_G2D_G2D		41
#define CLK_MOUT_CMU_G2D_MSCL		42
#define CLK_MOUT_CMU_HPM		43
#define CLK_MOUT_CMU_HSI0_BUS		44
#define CLK_MOUT_CMU_HSI0_DPGTC		45
#define CLK_MOUT_CMU_HSI0_USB31DRD	46
#define CLK_MOUT_CMU_HSI0_USBDP_DEBUG	47
#define CLK_MOUT_CMU_HSI1_BUS		48
#define CLK_MOUT_CMU_HSI1_MMC_CARD	49
#define CLK_MOUT_CMU_HSI1_PCIE		50
#define CLK_MOUT_CMU_HSI1_UFS_CARD	51
#define CLK_MOUT_CMU_HSI1_UFS_EMBD	52
#define CLK_MOUT_CMU_HSI2_BUS		53
#define CLK_MOUT_CMU_HSI2_PCIE		54
#define CLK_MOUT_CMU_IPP_BUS		55
#define CLK_MOUT_CMU_ITP_BUS		56
#define CLK_MOUT_CMU_MCSC_BUS		57
#define CLK_MOUT_CMU_MCSC_GDC		58
#define CLK_MOUT_CMU_CMU_BOOST_CPU	59
#define CLK_MOUT_CMU_MFC0_MFC0		60
#define CLK_MOUT_CMU_MFC0_WFD		61
#define CLK_MOUT_CMU_MIF_BUSP		62
#define CLK_MOUT_CMU_MIF_SWITCH		63
#define CLK_MOUT_CMU_NPU_BUS		64
#define CLK_MOUT_CMU_PERIC0_BUS		65
#define CLK_MOUT_CMU_PERIC0_IP		66
#define CLK_MOUT_CMU_PERIC1_BUS		67
#define CLK_MOUT_CMU_PERIC1_IP		68
#define CLK_MOUT_CMU_PERIS_BUS		69
#define CLK_MOUT_CMU_SSP_BUS		70
#define CLK_MOUT_CMU_TNR_BUS		71
#define CLK_MOUT_CMU_VRA_BUS		72
#define CLK_DOUT_CMU_APM_BUS		73
#define CLK_DOUT_CMU_AUD_CPU		74
#define CLK_DOUT_CMU_BUS0_BUS		75
#define CLK_DOUT_CMU_BUS1_BUS		76
#define CLK_DOUT_CMU_BUS1_SSS		77
#define CLK_DOUT_CMU_CIS_CLK0		78
#define CLK_DOUT_CMU_CIS_CLK1		79
#define CLK_DOUT_CMU_CIS_CLK2		80
#define CLK_DOUT_CMU_CIS_CLK3		81
#define CLK_DOUT_CMU_CIS_CLK4		82
#define CLK_DOUT_CMU_CIS_CLK5		83
#define CLK_DOUT_CMU_CMU_BOOST		84
#define CLK_DOUT_CMU_CORE_BUS		85
#define CLK_DOUT_CMU_CPUCL0_DBG_BUS	86
#define CLK_DOUT_CMU_CPUCL0_SWITCH	87
#define CLK_DOUT_CMU_CPUCL1_SWITCH	88
#define CLK_DOUT_CMU_CPUCL2_BUSP	89
#define CLK_DOUT_CMU_CPUCL2_SWITCH	90
#define CLK_DOUT_CMU_CSIS_BUS		91
#define CLK_DOUT_CMU_CSIS_OIS_MCU	92
#define CLK_DOUT_CMU_DNC_BUS		93
#define CLK_DOUT_CMU_DNC_BUSM		94
#define CLK_DOUT_CMU_DNS_BUS		95
#define CLK_DOUT_CMU_DSP_BUS		96
#define CLK_DOUT_CMU_G2D_G2D		97
#define CLK_DOUT_CMU_G2D_MSCL		98
#define CLK_DOUT_CMU_G3D_SWITCH		99
#define CLK_DOUT_CMU_HPM		100
#define CLK_DOUT_CMU_HSI0_BUS		101
#define CLK_DOUT_CMU_HSI0_DPGTC		102
#define CLK_DOUT_CMU_HSI0_USB31DRD	103
#define CLK_DOUT_CMU_HSI0_USBDP_DEBUG	104
#define CLK_DOUT_CMU_HSI1_BUS		105
#define CLK_DOUT_CMU_HSI1_MMC_CARD	106
#define CLK_DOUT_CMU_HSI1_PCIE		107
#define CLK_DOUT_CMU_HSI1_UFS_CARD	108
#define CLK_DOUT_CMU_HSI1_UFS_EMBD	109
#define CLK_DOUT_CMU_HSI2_BUS		110
#define CLK_DOUT_CMU_HSI2_PCIE		111
#define CLK_DOUT_CMU_IPP_BUS		112
#define CLK_DOUT_CMU_ITP_BUS		113
#define CLK_DOUT_CMU_MCSC_BUS		114
#define CLK_DOUT_CMU_MCSC_GDC		115
#define CLK_DOUT_CMU_CMU_BOOST_CPU	116
#define CLK_DOUT_CMU_MFC0_MFC0		117
#define CLK_DOUT_CMU_MFC0_WFD		118
#define CLK_DOUT_CMU_MIF_BUSP		119
#define CLK_DOUT_CMU_NPU_BUS		120
#define CLK_DOUT_CMU_OTP		121
#define CLK_DOUT_CMU_PERIC0_BUS		122
#define CLK_DOUT_CMU_PERIC0_IP		123
#define CLK_DOUT_CMU_PERIC1_BUS		124
#define CLK_DOUT_CMU_PERIC1_IP		125
#define CLK_DOUT_CMU_PERIS_BUS		126
#define CLK_DOUT_CMU_SSP_BUS		127
#define CLK_DOUT_CMU_TNR_BUS		128
#define CLK_DOUT_CMU_VRA_BUS		129
#define CLK_DOUT_CMU_DPU		130
#define CLK_DOUT_CMU_DPU_ALT		131
#define CLK_DOUT_CMU_SHARED0_DIV2	132
#define CLK_DOUT_CMU_SHARED0_DIV3	133
#define CLK_DOUT_CMU_SHARED0_DIV4	134
#define CLK_DOUT_CMU_SHARED1_DIV2	135
#define CLK_DOUT_CMU_SHARED1_DIV3	136
#define CLK_DOUT_CMU_SHARED1_DIV4	137
#define CLK_DOUT_CMU_SHARED2_DIV2	138
#define CLK_DOUT_CMU_SHARED4_DIV2	139
#define CLK_DOUT_CMU_SHARED4_DIV3	140
#define CLK_DOUT_CMU_SHARED4_DIV4	141
#define CLK_GOUT_CMU_G3D_BUS		142
#define CLK_GOUT_CMU_MIF_SWITCH		143
#define CLK_GOUT_CMU_APM_BUS		144
#define CLK_GOUT_CMU_AUD_CPU		145
#define CLK_GOUT_CMU_BUS0_BUS		146
#define CLK_GOUT_CMU_BUS1_BUS		147
#define CLK_GOUT_CMU_BUS1_SSS		148
#define CLK_GOUT_CMU_CIS_CLK0		149
#define CLK_GOUT_CMU_CIS_CLK1		150
#define CLK_GOUT_CMU_CIS_CLK2		151
#define CLK_GOUT_CMU_CIS_CLK3		152
#define CLK_GOUT_CMU_CIS_CLK4		153
#define CLK_GOUT_CMU_CIS_CLK5		154
#define CLK_GOUT_CMU_CORE_BUS		155
#define CLK_GOUT_CMU_CPUCL0_DBG_BUS	156
#define CLK_GOUT_CMU_CPUCL0_SWITCH	157
#define CLK_GOUT_CMU_CPUCL1_SWITCH	158
#define CLK_GOUT_CMU_CPUCL2_BUSP	159
#define CLK_GOUT_CMU_CPUCL2_SWITCH	160
#define CLK_GOUT_CMU_CSIS_BUS		161
#define CLK_GOUT_CMU_CSIS_OIS_MCU	162
#define CLK_GOUT_CMU_DNC_BUS		163
#define CLK_GOUT_CMU_DNC_BUSM		164
#define CLK_GOUT_CMU_DNS_BUS		165
#define CLK_GOUT_CMU_DPU		166
#define CLK_GOUT_CMU_DPU_BUS		167
#define CLK_GOUT_CMU_DSP_BUS		168
#define CLK_GOUT_CMU_G2D_G2D		169
#define CLK_GOUT_CMU_G2D_MSCL		170
#define CLK_GOUT_CMU_G3D_SWITCH		171
#define CLK_GOUT_CMU_HPM		172
#define CLK_GOUT_CMU_HSI0_BUS		173
#define CLK_GOUT_CMU_HSI0_DPGTC		174
#define CLK_GOUT_CMU_HSI0_USB31DRD	175
#define CLK_GOUT_CMU_HSI0_USBDP_DEBUG	176
#define CLK_GOUT_CMU_HSI1_BUS		177
#define CLK_GOUT_CMU_HSI1_MMC_CARD	178
#define CLK_GOUT_CMU_HSI1_PCIE		179
#define CLK_GOUT_CMU_HSI1_UFS_CARD	180
#define CLK_GOUT_CMU_HSI1_UFS_EMBD	181
#define CLK_GOUT_CMU_HSI2_BUS		182
#define CLK_GOUT_CMU_HSI2_PCIE		183
#define CLK_GOUT_CMU_IPP_BUS		184
#define CLK_GOUT_CMU_ITP_BUS		185
#define CLK_GOUT_CMU_MCSC_BUS		186
#define CLK_GOUT_CMU_MCSC_GDC		187
#define CLK_GOUT_CMU_MFC0_MFC0		188
#define CLK_GOUT_CMU_MFC0_WFD		189
#define CLK_GOUT_CMU_MIF_BUSP		190
#define CLK_GOUT_CMU_NPU_BUS		191
#define CLK_GOUT_CMU_PERIC0_BUS		192
#define CLK_GOUT_CMU_PERIC0_IP		193
#define CLK_GOUT_CMU_PERIC1_BUS		194
#define CLK_GOUT_CMU_PERIC1_IP		195
#define CLK_GOUT_CMU_PERIS_BUS		196
#define CLK_GOUT_CMU_SSP_BUS		197
#define CLK_GOUT_CMU_TNR_BUS		198
#define CLK_GOUT_CMU_VRA_BUS		199
#define CLK_MOUT_CMU_CMUREF		200
#define CLK_MOUT_CMU_DPU_BUS		201
#define CLK_MOUT_CMU_CLK_CMUREF		202
#define CLK_DOUT_CMU_CLK_CMUREF		203

/* CMU_HSI0 */
#define CLK_MOUT_HSI0_BUS_USER				1
#define CLK_MOUT_HSI0_USB31DRD_USER			2
#define CLK_MOUT_HSI0_USBDP_DEBUG_USER			3
#define CLK_MOUT_HSI0_DPGTC_USER			4
#define CLK_GOUT_HSI0_DP_LINK_DP_GTC_CLK		5
#define CLK_GOUT_HSI0_DP_LINK_PCLK			6
#define CLK_GOUT_HSI0_D_TZPC_HSI0_PCLK			7
#define CLK_GOUT_HSI0_LHM_AXI_P_HSI0_CLK		8
#define CLK_GOUT_HSI0_PPMU_HSI0_BUS1_ACLK		9
#define CLK_GOUT_HSI0_PPMU_HSI0_BUS1_PCLK		10
#define CLK_GOUT_HSI0_CLK_HSI0_BUS_CLK			11
#define CLK_GOUT_HSI0_SYSMMU_USB_CLK_S2			12
#define CLK_GOUT_HSI0_SYSREG_HSI0_PCLK			13
#define CLK_GOUT_HSI0_USB31DRD_ACLK_PHYCTRL		14
#define CLK_GOUT_HSI0_USB31DRD_BUS_CLK_EARLY		15
#define CLK_GOUT_HSI0_USB31DRD_USB31DRD_REF_CLK_40	16
#define CLK_GOUT_HSI0_USB31DRD_USBDPPHY_REF_SOC_PLL	17
#define CLK_GOUT_HSI0_USB31DRD_USBDPPHY_SCL_APB		18
#define CLK_GOUT_HSI0_USB31DRD_USBPCS_APB_CLK		19
#define CLK_GOUT_HSI0_VGEN_LITE_HSI0_CLK		20
#define CLK_GOUT_HSI0_CMU_HSI0_PCLK			21
#define CLK_GOUT_HSI0_XIU_D_HSI0_ACLK			22
#define CLK_GOUT_HSI0_LHS_ACEL_D_HSI0_CLK		23

/* CMU_PERIC0 */
#define CLK_MOUT_PERIC0_BUS_USER		1
#define CLK_MOUT_PERIC0_UART_DBG		2
#define CLK_MOUT_PERIC0_USI00_USI_USER		3
#define CLK_MOUT_PERIC0_USI01_USI_USER		4
#define CLK_MOUT_PERIC0_USI02_USI_USER		5
#define CLK_MOUT_PERIC0_USI03_USI_USER		6
#define CLK_MOUT_PERIC0_USI04_USI_USER		7
#define CLK_MOUT_PERIC0_USI05_USI_USER		8
#define CLK_MOUT_PERIC0_USI13_USI_USER		9
#define CLK_MOUT_PERIC0_USI14_USI_USER		10
#define CLK_MOUT_PERIC0_USI15_USI_USER		11
#define CLK_MOUT_PERIC0_USI_I2C_USER		12
#define CLK_DOUT_PERIC0_UART_DBG		13
#define CLK_DOUT_PERIC0_USI00_USI		14
#define CLK_DOUT_PERIC0_USI01_USI		15
#define CLK_DOUT_PERIC0_USI02_USI		16
#define CLK_DOUT_PERIC0_USI03_USI		17
#define CLK_DOUT_PERIC0_USI04_USI		18
#define CLK_DOUT_PERIC0_USI05_USI		19
#define CLK_DOUT_PERIC0_USI13_USI		20
#define CLK_DOUT_PERIC0_USI14_USI		21
#define CLK_DOUT_PERIC0_USI15_USI		22
#define CLK_DOUT_PERIC0_USI_I2C			23
#define CLK_GOUT_PERIC0_CMU_PCLK		24
#define CLK_GOUT_PERIC0_OSCCLK_CLK		25
#define CLK_GOUT_PERIC0_D_TZPC_PCLK		26
#define CLK_GOUT_PERIC0_GPIO_PCLK		27
#define CLK_GOUT_PERIC0_LHM_AXI_P_CLK		28
#define CLK_GOUT_PERIC0_TOP0_IPCLK_10		29
#define CLK_GOUT_PERIC0_TOP0_IPCLK_11		30
#define CLK_GOUT_PERIC0_TOP0_IPCLK_12		31
#define CLK_GOUT_PERIC0_TOP0_IPCLK_13		32
#define CLK_GOUT_PERIC0_TOP0_IPCLK_14		33
#define CLK_GOUT_PERIC0_TOP0_IPCLK_15		34
#define CLK_GOUT_PERIC0_TOP0_IPCLK_4		35
#define CLK_GOUT_PERIC0_TOP0_IPCLK_5		36
#define CLK_GOUT_PERIC0_TOP0_IPCLK_6		37
#define CLK_GOUT_PERIC0_TOP0_IPCLK_7		38
#define CLK_GOUT_PERIC0_TOP0_IPCLK_8		39
#define CLK_GOUT_PERIC0_TOP0_IPCLK_9		40
#define CLK_GOUT_PERIC0_TOP0_PCLK_10		41
#define CLK_GOUT_PERIC0_TOP0_PCLK_11		42
#define CLK_GOUT_PERIC0_TOP0_PCLK_12		43
#define CLK_GOUT_PERIC0_TOP0_PCLK_13		44
#define CLK_GOUT_PERIC0_TOP0_PCLK_14		45
#define CLK_GOUT_PERIC0_TOP0_PCLK_15		46
#define CLK_GOUT_PERIC0_TOP0_PCLK_4		47
#define CLK_GOUT_PERIC0_TOP0_PCLK_5		48
#define CLK_GOUT_PERIC0_TOP0_PCLK_6		49
#define CLK_GOUT_PERIC0_TOP0_PCLK_7		50
#define CLK_GOUT_PERIC0_TOP0_PCLK_8		51
#define CLK_GOUT_PERIC0_TOP0_PCLK_9		52
#define CLK_GOUT_PERIC0_TOP1_IPCLK_0		53
#define CLK_GOUT_PERIC0_TOP1_IPCLK_3		54
#define CLK_GOUT_PERIC0_TOP1_IPCLK_4		55
#define CLK_GOUT_PERIC0_TOP1_IPCLK_5		56
#define CLK_GOUT_PERIC0_TOP1_IPCLK_6		57
#define CLK_GOUT_PERIC0_TOP1_IPCLK_7		58
#define CLK_GOUT_PERIC0_TOP1_IPCLK_8		59
#define CLK_GOUT_PERIC0_TOP1_PCLK_0		60
#define CLK_GOUT_PERIC0_TOP1_PCLK_15		61
#define CLK_GOUT_PERIC0_TOP1_PCLK_3		62
#define CLK_GOUT_PERIC0_TOP1_PCLK_4		63
#define CLK_GOUT_PERIC0_TOP1_PCLK_5		64
#define CLK_GOUT_PERIC0_TOP1_PCLK_6		65
#define CLK_GOUT_PERIC0_TOP1_PCLK_7		66
#define CLK_GOUT_PERIC0_TOP1_PCLK_8		67
#define CLK_GOUT_PERIC0_BUSP_CLK		68
#define CLK_GOUT_PERIC0_UART_DBG_CLK		69
#define CLK_GOUT_PERIC0_USI00_USI_CLK		70
#define CLK_GOUT_PERIC0_USI01_USI_CLK		71
#define CLK_GOUT_PERIC0_USI02_USI_CLK		72
#define CLK_GOUT_PERIC0_USI03_USI_CLK		73
#define CLK_GOUT_PERIC0_USI04_USI_CLK		74
#define CLK_GOUT_PERIC0_USI05_USI_CLK		75
#define CLK_GOUT_PERIC0_USI13_USI_CLK		76
#define CLK_GOUT_PERIC0_USI14_USI_CLK		77
#define CLK_GOUT_PERIC0_USI15_USI_CLK		78
#define CLK_GOUT_PERIC0_USI_I2C_CLK		79
#define CLK_GOUT_PERIC0_SYSREG_PCLK		80

/* CMU_PERIC1 */
#define CLK_MOUT_PERIC1_BUS_USER		1
#define CLK_MOUT_PERIC1_UART_BT_USER		2
#define CLK_MOUT_PERIC1_USI06_USI_USER		3
#define CLK_MOUT_PERIC1_USI07_USI_USER		4
#define CLK_MOUT_PERIC1_USI08_USI_USER		5
#define CLK_MOUT_PERIC1_USI09_USI_USER		6
#define CLK_MOUT_PERIC1_USI10_USI_USER		7
#define CLK_MOUT_PERIC1_USI11_USI_USER		8
#define CLK_MOUT_PERIC1_USI12_USI_USER		9
#define CLK_MOUT_PERIC1_USI18_USI_USER		10
#define CLK_MOUT_PERIC1_USI16_USI_USER		11
#define CLK_MOUT_PERIC1_USI17_USI_USER		12
#define CLK_MOUT_PERIC1_USI_I2C_USER            13
#define CLK_DOUT_PERIC1_UART_BT			14
#define CLK_DOUT_PERIC1_USI06_USI		15
#define CLK_DOUT_PERIC1_USI07_USI		16
#define CLK_DOUT_PERIC1_USI08_USI		17
#define CLK_DOUT_PERIC1_USI18_USI		18
#define CLK_DOUT_PERIC1_USI12_USI		19
#define CLK_DOUT_PERIC1_USI09_USI		20
#define CLK_DOUT_PERIC1_USI10_USI		21
#define CLK_DOUT_PERIC1_USI11_USI		22
#define CLK_DOUT_PERIC1_USI16_USI		23
#define CLK_DOUT_PERIC1_USI17_USI		24
#define CLK_DOUT_PERIC1_USI_I2C			25
#define CLK_GOUT_PERIC1_CMU_PCLK		26
#define CLK_GOUT_PERIC1_UART_BT_CLK		27
#define CLK_GOUT_PERIC1_USI12_USI_CLK		28
#define CLK_GOUT_PERIC1_USI18_USI_CLK		29
#define CLK_GOUT_PERIC1_D_TZPC_PCLK		30
#define CLK_GOUT_PERIC1_GPIO_PCLK		31
#define CLK_GOUT_PERIC1_LHM_AXI_P_CSIS_CLK	32
#define CLK_GOUT_PERIC1_LHM_AXI_P_CLK		33
#define CLK_GOUT_PERIC1_TOP0_IPCLK_10		34
#define CLK_GOUT_PERIC1_TOP0_IPCLK_11		35
#define CLK_GOUT_PERIC1_TOP0_IPCLK_12		36
#define CLK_GOUT_PERIC1_TOP0_IPCLK_13		37
#define CLK_GOUT_PERIC1_TOP0_IPCLK_14		38
#define CLK_GOUT_PERIC1_TOP0_IPCLK_15		39
#define CLK_GOUT_PERIC1_TOP0_IPCLK_4		40
#define CLK_GOUT_PERIC1_TOP0_PCLK_10		41
#define CLK_GOUT_PERIC1_TOP0_PCLK_11		42
#define CLK_GOUT_PERIC1_TOP0_PCLK_12		43
#define CLK_GOUT_PERIC1_TOP0_PCLK_13		44
#define CLK_GOUT_PERIC1_TOP0_PCLK_14		45
#define CLK_GOUT_PERIC1_TOP0_PCLK_15		46
#define CLK_GOUT_PERIC1_TOP0_PCLK_4		47
#define CLK_GOUT_PERIC1_TOP1_IPCLK_0		48
#define CLK_GOUT_PERIC1_TOP1_IPCLK_1		49
#define CLK_GOUT_PERIC1_TOP1_IPCLK_10		50
#define CLK_GOUT_PERIC1_TOP1_IPCLK_12		51
#define CLK_GOUT_PERIC1_TOP1_IPCLK_13		52
#define CLK_GOUT_PERIC1_TOP1_IPCLK_14		53
#define CLK_GOUT_PERIC1_TOP1_IPCLK_15		54
#define CLK_GOUT_PERIC1_TOP1_IPCLK_2		55
#define CLK_GOUT_PERIC1_TOP1_IPCLK_3		56
#define CLK_GOUT_PERIC1_TOP1_IPCLK_4		57
#define CLK_GOUT_PERIC1_TOP1_IPCLK_5		58
#define CLK_GOUT_PERIC1_TOP1_IPCLK_6		59
#define CLK_GOUT_PERIC1_TOP1_IPCLK_7		60
#define CLK_GOUT_PERIC1_TOP1_IPCLK_9		61
#define CLK_GOUT_PERIC1_TOP1_PCLK_0		62
#define CLK_GOUT_PERIC1_TOP1_PCLK_1		63
#define CLK_GOUT_PERIC1_TOP1_PCLK_10		64
#define CLK_GOUT_PERIC1_TOP1_PCLK_12		65
#define CLK_GOUT_PERIC1_TOP1_PCLK_13		66
#define CLK_GOUT_PERIC1_TOP1_PCLK_14		67
#define CLK_GOUT_PERIC1_TOP1_PCLK_15		68
#define CLK_GOUT_PERIC1_TOP1_PCLK_2		69
#define CLK_GOUT_PERIC1_TOP1_PCLK_3		70
#define CLK_GOUT_PERIC1_TOP1_PCLK_4		71
#define CLK_GOUT_PERIC1_TOP1_PCLK_5		72
#define CLK_GOUT_PERIC1_TOP1_PCLK_6		73
#define CLK_GOUT_PERIC1_TOP1_PCLK_7		74
#define CLK_GOUT_PERIC1_TOP1_PCLK_9		75
#define CLK_GOUT_PERIC1_BUSP_CLK		76
#define CLK_GOUT_PERIC1_OSCCLK_CLK		77
#define CLK_GOUT_PERIC1_USI06_USI_CLK		78
#define CLK_GOUT_PERIC1_USI07_USI_CLK		79
#define CLK_GOUT_PERIC1_USI08_USI_CLK		80
#define CLK_GOUT_PERIC1_USI09_USI_CLK		81
#define CLK_GOUT_PERIC1_USI10_USI_CLK		82
#define CLK_GOUT_PERIC1_USI11_USI_CLK		83
#define CLK_GOUT_PERIC1_USI16_USI_CLK		84
#define CLK_GOUT_PERIC1_USI17_USI_CLK		85
#define CLK_GOUT_PERIC1_USI_I2C_CLK		86
#define CLK_GOUT_PERIC1_SYSREG_PCLK		87
#define CLK_GOUT_PERIC1_USI16_I3C_PCLK		88
#define CLK_GOUT_PERIC1_USI16_I3C_SCLK		89
#define CLK_GOUT_PERIC1_USI17_I3C_PCLK		90
#define CLK_GOUT_PERIC1_USI17_I3C_SCLK		91
#define CLK_GOUT_PERIC1_XIU_P_ACLK		92

/* CMU_PERIS */
#define CLK_MOUT_PERIS_BUS_USER			1
#define CLK_MOUT_PERIS_CLK_PERIS_GIC		2
#define CLK_GOUT_PERIS_SYSREG_PERIS_PCLK	3
#define CLK_GOUT_PERIS_WDT_CLUSTER2_PCLK	4
#define CLK_GOUT_PERIS_WDT_CLUSTER0_PCLK	5
#define CLK_CLK_PERIS_PERIS_CMU_PERIS_PCLK	6
#define CLK_GOUT_PERIS_CLK_PERIS_BUSP_CLK	7
#define CLK_GOUT_PERIS_CLK_PERIS_OSCCLK_CLK	8
#define CLK_GOUT_PERIS_CLK_PERIS_GIC_CLK	9
#define CLK_GOUT_PERIS_AD_AXI_P_PERIS_ACLKM	10
#define CLK_GOUT_PERIS_OTP_CON_BIRA_PCLK	11
#define CLK_GOUT_PERIS_GIC_CLK			12
#define CLK_GOUT_PERIS_LHM_AXI_P_PERIS_CLK	13
#define CLK_GOUT_PERIS_MCT_PCLK			14
#define CLK_GOUT_PERIS_OTP_CON_TOP_PCLK		15
#define CLK_GOUT_PERIS_D_TZPC_PERIS_PCLK	16
#define CLK_GOUT_PERIS_TMU_TOP_PCLK		17
#define CLK_GOUT_PERIS_OTP_CON_BIRA_OSCCLK	18
#define CLK_GOUT_PERIS_OTP_CON_TOP_OSCCLK	19

#endif
