/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.ComparableValue;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.constant.ConstantIntValue;

public interface IntValue
extends IntValueStream,
AnalyticsValue {
    public int getInt();

    public static abstract class AbstractIntValue
    implements CastingIntValue {
        @Override
        public long getLong() {
            return this.getInt();
        }

        @Override
        public float getFloat() {
            return this.getInt();
        }

        @Override
        public double getDouble() {
            return this.getInt();
        }

        @Override
        public String getString() {
            int val = this.getInt();
            return this.exists() ? Integer.toString(val) : null;
        }

        @Override
        public Object getObject() {
            int val = this.getInt();
            return this.exists() ? Integer.valueOf(val) : null;
        }

        @Override
        public void streamInts(IntConsumer cons) {
            int val = this.getInt();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long val = this.getLong();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamFloats(FloatConsumer cons) {
            float val = this.getFloat();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            double val = this.getDouble();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            String val = this.getString();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            Object val = this.getObject();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public AnalyticsValue convertToConstant() {
            if (this.getExpressionType().equals((Object)AnalyticsValueStream.ExpressionType.CONST)) {
                return new ConstantIntValue(this.getInt());
            }
            return this;
        }

        @Override
        public ExpressionComparator<Integer> getObjectComparator(String expression) {
            return new ExpressionComparator<Integer>(expression);
        }
    }

    public static interface CastingIntValue
    extends IntValue,
    LongValue,
    FloatValue,
    DoubleValue,
    StringValue,
    ComparableValue {
    }
}

