/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIIPropertyListParser;
import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.ByteOrderMarkReader;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PropertyListParser {
    private static final int TYPE_XML = 0;
    private static final int TYPE_BINARY = 1;
    private static final int TYPE_ASCII = 2;
    private static final int TYPE_ERROR_BLANK = 10;
    private static final int TYPE_ERROR_UNKNOWN = 11;
    private static final int READ_BUFFER_LENGTH = 2048;

    protected PropertyListParser() {
    }

    private static int determineType(String dataBeginning) {
        if ((dataBeginning = dataBeginning.trim()).length() == 0) {
            return 10;
        }
        if (dataBeginning.startsWith("bplist")) {
            return 1;
        }
        if (dataBeginning.startsWith("(") || dataBeginning.startsWith("{") || dataBeginning.startsWith("/")) {
            return 2;
        }
        if (dataBeginning.startsWith("<")) {
            return 0;
        }
        return 11;
    }

    private static int determineType(InputStream is, int offset) throws IOException {
        int b;
        int index = offset;
        int readLimit = index + 1024;
        if (is.markSupported()) {
            is.mark(readLimit);
        }
        is.skip(offset);
        ByteOrderMarkReader bomReader = new ByteOrderMarkReader();
        boolean bom = true;
        do {
            if (++index <= readLimit) continue;
            is.reset();
            return PropertyListParser.determineType(is, readLimit);
        } while ((b = is.read()) != -1 && (b == 32 || b == 9 || b == 13 || b == 10 || b == 12 || (bom &= bomReader.readByte(b))));
        if (b == -1) {
            return 10;
        }
        String charset = bomReader.getDetectedCharset();
        if (charset == null) {
            charset = "UTF-8";
        }
        byte[] magicBytes = new byte[8];
        magicBytes[0] = (byte)b;
        int read = is.read(magicBytes, 1, 7);
        int type = PropertyListParser.determineType(new String(magicBytes, 0, read, Charset.forName(charset)));
        if (is.markSupported()) {
            is.reset();
        }
        return type;
    }

    protected static byte[] readAll(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((read = in.read(buf, 0, 2048)) != -1) {
            outputStream.write(buf, 0, read);
        }
        return outputStream.toByteArray();
    }

    public static NSObject parse(String filePath) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        return PropertyListParser.parse(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSObject parse(File f) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        FileInputStream fileInputStream = new FileInputStream(f);
        try {
            NSObject nSObject = PropertyListParser.parse(fileInputStream);
            return nSObject;
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static NSObject parse(byte[] bytes) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        return PropertyListParser.parse(new ByteArrayInputStream(bytes));
    }

    public static NSObject parse(InputStream is) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        switch (PropertyListParser.determineType(is, 0)) {
            case 1: {
                return BinaryPropertyListParser.parse(is);
            }
            case 0: {
                return XMLPropertyListParser.parse(is);
            }
            case 2: {
                return ASCIIPropertyListParser.parse(is);
            }
            case 10: {
                return null;
            }
        }
        throw new PropertyListFormatException("The given data is not a property list of a supported format.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsXML(NSObject root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(out);
        try {
            PropertyListParser.saveAsXML(root, fileOutputStream);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveAsXML(NSObject root, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
        w.write(root.toXMLPropertyList());
        w.flush();
    }

    public static void convertToXml(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        PropertyListParser.saveAsXML(root, out);
    }

    public static void saveAsBinary(NSObject root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        BinaryPropertyListWriter.write(out, root);
    }

    public static void saveAsBinary(NSObject root, OutputStream out) throws IOException {
        BinaryPropertyListWriter.write(out, root);
    }

    public static void convertToBinary(File in, File out) throws IOException, ParserConfigurationException, ParseException, SAXException, PropertyListFormatException {
        NSObject root = PropertyListParser.parse(in);
        PropertyListParser.saveAsBinary(root, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsASCII(NSDictionary root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        try {
            w.write(root.toASCIIPropertyList());
        }
        finally {
            try {
                w.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsASCII(NSArray root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        try {
            w.write(root.toASCIIPropertyList());
        }
        finally {
            try {
                w.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void convertToASCII(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        if (root instanceof NSDictionary) {
            PropertyListParser.saveAsASCII((NSDictionary)root, out);
        } else if (root instanceof NSArray) {
            PropertyListParser.saveAsASCII((NSArray)root, out);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsGnuStepASCII(NSDictionary root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        try {
            w.write(root.toGnuStepASCIIPropertyList());
        }
        finally {
            try {
                w.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsGnuStepASCII(NSArray root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        try {
            w.write(root.toGnuStepASCIIPropertyList());
        }
        finally {
            try {
                w.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void convertToGnuStepASCII(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        if (root instanceof NSDictionary) {
            PropertyListParser.saveAsGnuStepASCII((NSDictionary)root, out);
        } else if (root instanceof NSArray) {
            PropertyListParser.saveAsGnuStepASCII((NSArray)root, out);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array!");
        }
    }
}

