/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.ByteArrayUtil;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.tuple.DeserializeResult;
import com.yahoo.sketches.tuple.SerializerDeserializer;
import com.yahoo.sketches.tuple.Sketch;
import com.yahoo.sketches.tuple.Summary;
import com.yahoo.sketches.tuple.SummaryDeserializer;
import java.lang.reflect.Array;
import java.nio.ByteOrder;

public class CompactSketch<S extends Summary>
extends Sketch<S> {
    private static final byte serialVersionWithSummaryClassNameUID = 1;
    private static final byte serialVersionUID = 2;

    CompactSketch(long[] keys, S[] summaries, long theta, boolean isEmpty) {
        this.keys_ = keys;
        this.summaries_ = summaries;
        this.theta_ = theta;
        this.isEmpty_ = isEmpty;
    }

    CompactSketch(Memory mem, SummaryDeserializer<S> deserializer) {
        boolean hasEntries;
        boolean isThetaIncluded;
        boolean isBigEndian;
        int offset = 0;
        byte preambleLongs = mem.getByte((long)offset++);
        byte version = mem.getByte((long)offset++);
        byte familyId = mem.getByte((long)offset++);
        SerializerDeserializer.validateFamily(familyId, preambleLongs);
        if (version > 2) {
            throw new SketchesArgumentException("Unsupported serial version. Expected: 2 or lower, actual: " + version);
        }
        SerializerDeserializer.validateType(mem.getByte((long)offset++), SerializerDeserializer.SketchType.CompactSketch);
        byte flags = mem.getByte((long)offset++);
        boolean bl = isBigEndian = (flags & 1 << Flags.IS_BIG_ENDIAN.ordinal()) > 0;
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Byte order mismatch");
        }
        this.isEmpty_ = (flags & 1 << Flags.IS_EMPTY.ordinal()) > 0;
        boolean bl2 = isThetaIncluded = (flags & 1 << Flags.IS_THETA_INCLUDED.ordinal()) > 0;
        if (isThetaIncluded) {
            this.theta_ = mem.getLong((long)offset);
            offset += 8;
        } else {
            this.theta_ = Long.MAX_VALUE;
        }
        boolean bl3 = hasEntries = (flags & 1 << Flags.HAS_ENTRIES.ordinal()) > 0;
        if (hasEntries) {
            int i;
            byte classNameLength = 0;
            if (version == 1) {
                classNameLength = mem.getByte((long)offset++);
            }
            int count = mem.getInt((long)offset);
            offset += 4;
            if (version == 1) {
                offset += classNameLength;
            }
            this.keys_ = new long[count];
            for (i = 0; i < count; ++i) {
                this.keys_[i] = mem.getLong((long)offset);
                offset += 8;
            }
            for (i = 0; i < count; ++i) {
                Memory memRegion = mem.region((long)offset, mem.getCapacity() - (long)offset);
                DeserializeResult<S> result = deserializer.heapifySummary(memRegion);
                Summary summary = (Summary)result.getObject();
                offset += result.getSize();
                if (this.summaries_ == null) {
                    this.summaries_ = (Summary[])Array.newInstance(summary.getClass(), count);
                }
                this.summaries_[i] = summary;
            }
        }
    }

    @Override
    public int getRetainedEntries() {
        return this.keys_ == null ? 0 : this.keys_.length;
    }

    @Override
    public byte[] toByteArray() {
        boolean isThetaIncluded;
        int summariesBytesLength = 0;
        Object summariesBytes = null;
        int count = this.getRetainedEntries();
        if (count > 0) {
            summariesBytes = new byte[count][];
            for (int i = 0; i < count; ++i) {
                summariesBytes[i] = this.summaries_[i].toByteArray();
                summariesBytesLength += summariesBytes[i].length;
            }
        }
        int sizeBytes = 5;
        boolean bl = isThetaIncluded = this.theta_ < Long.MAX_VALUE;
        if (isThetaIncluded) {
            sizeBytes += 8;
        }
        if (count > 0) {
            sizeBytes += 4 + 8 * count + summariesBytesLength;
        }
        byte[] bytes = new byte[sizeBytes];
        int offset = 0;
        bytes[offset++] = 1;
        bytes[offset++] = 2;
        bytes[offset++] = (byte)Family.TUPLE.getID();
        bytes[offset++] = (byte)SerializerDeserializer.SketchType.CompactSketch.ordinal();
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        bytes[offset++] = (byte)((isBigEndian ? 1 << Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isEmpty_ ? 1 << Flags.IS_EMPTY.ordinal() : 0) | (count > 0 ? 1 << Flags.HAS_ENTRIES.ordinal() : 0) | (isThetaIncluded ? 1 << Flags.IS_THETA_INCLUDED.ordinal() : 0));
        if (isThetaIncluded) {
            ByteArrayUtil.putLongLE(bytes, offset, this.theta_);
            offset += 8;
        }
        if (count > 0) {
            int i;
            ByteArrayUtil.putIntLE(bytes, offset, this.getRetainedEntries());
            offset += 4;
            for (i = 0; i < count; ++i) {
                ByteArrayUtil.putLongLE(bytes, offset, this.keys_[i]);
                offset += 8;
            }
            for (i = 0; i < count; ++i) {
                System.arraycopy(summariesBytes[i], 0, bytes, offset, summariesBytes[i].length);
                offset += summariesBytes[i].length;
            }
        }
        return bytes;
    }

    private static enum Flags {
        IS_BIG_ENDIAN,
        IS_EMPTY,
        HAS_ENTRIES,
        IS_THETA_INCLUDED;

    }
}

