/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import oracle.ons.BodyElement;

public class BodySegment {
    private List<BodyElement> eltList = new LinkedList<BodyElement>();
    private List<BodySegment> segList = new ArrayList<BodySegment>();
    private String segName;
    private int nameLen;
    private int level;

    public BodySegment(String string) {
        this(string, 0);
    }

    BodySegment(String string, int n) {
        this.segName = string;
        this.nameLen = string.length();
        this.level = n;
    }

    int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.segName;
    }

    public int getNameLength() {
        return this.nameLen;
    }

    public void addElement(BodyElement bodyElement) {
        this.eltList.add(bodyElement);
    }

    public String getElementValue(String string) {
        BodyElement bodyElement = null;
        ListIterator<BodyElement> listIterator = this.eltList.listIterator(0);
        while (listIterator.hasNext() && ((bodyElement = listIterator.next()).getNameLength() != string.length() || !bodyElement.getName().equals(string))) {
            bodyElement = null;
        }
        if (bodyElement == null) {
            return null;
        }
        return bodyElement.getValue();
    }

    public BodyElement getFirstElement() {
        return this.eltList.get(0);
    }

    public BodyElement getElement(int n) {
        return this.eltList.get(n);
    }

    public List getElementList() {
        return this.eltList;
    }

    public List<BodySegment> getSegmentList() {
        return this.segList;
    }

    public void addSegment(BodySegment bodySegment) {
        if (bodySegment == null) {
            return;
        }
        this.segList.add(bodySegment);
    }
}

