/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.DescriptorUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.jboss.jandex.MethodInfo;

public class MethodDescriptor {
    public static final String INIT = "<init>";
    public static final String CLINIT = "<clinit>";
    private final String declaringClass;
    private final String name;
    private final String returnType;
    private final String[] parameterTypes;
    private final String descriptor;

    private MethodDescriptor(String declaringClass, String name, String returnType, String ... parameterTypes) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.descriptor = DescriptorUtils.methodSignatureToDescriptor(returnType, parameterTypes);
        for (String p : parameterTypes) {
            if (p.length() == 1 || p.startsWith("L") && p.endsWith(";") || p.startsWith("[")) continue;
            throw new IllegalArgumentException("Invalid parameter type " + p + " it must be in the JVM descriptor format");
        }
        if (!(returnType.length() == 1 || returnType.startsWith("L") && returnType.endsWith(";") || returnType.startsWith("["))) {
            throw new IllegalArgumentException("Invalid return type " + returnType + " it must be in the JVM descriptor format");
        }
    }

    private MethodDescriptor(MethodInfo info) {
        this.name = info.name();
        this.returnType = DescriptorUtils.typeToString(info.returnType());
        String[] paramTypes = new String[info.parametersCount()];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = DescriptorUtils.typeToString(info.parameterType(i));
        }
        this.parameterTypes = paramTypes;
        this.declaringClass = info.declaringClass().toString().replace('.', '/');
        this.descriptor = DescriptorUtils.methodSignatureToDescriptor(this.returnType, this.parameterTypes);
    }

    public static MethodDescriptor ofMethod(String declaringClass, String name, String returnType, String ... parameterTypes) {
        return new MethodDescriptor(DescriptorUtils.objectToInternalClassName(declaringClass), name, DescriptorUtils.objectToDescriptor(returnType), DescriptorUtils.objectsToDescriptor(parameterTypes));
    }

    public static MethodDescriptor ofMethod(Class<?> declaringClass, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        String[] args = new String[parameterTypes.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = DescriptorUtils.classToStringRepresentation(parameterTypes[i]);
        }
        return new MethodDescriptor(DescriptorUtils.objectToInternalClassName(declaringClass), name, DescriptorUtils.classToStringRepresentation(returnType), args);
    }

    public static MethodDescriptor ofMethod(Method method) {
        return MethodDescriptor.ofMethod(method.getDeclaringClass(), method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public static MethodDescriptor ofMethod(Object declaringClass, String name, Object returnType, Object ... parameterTypes) {
        return new MethodDescriptor(DescriptorUtils.objectToInternalClassName(declaringClass), name, DescriptorUtils.objectToDescriptor(returnType), DescriptorUtils.objectsToDescriptor(parameterTypes));
    }

    public static MethodDescriptor ofConstructor(String declaringClass, String ... parameterTypes) {
        return MethodDescriptor.ofMethod(declaringClass, INIT, Void.TYPE.getName(), parameterTypes);
    }

    public static MethodDescriptor ofConstructor(Class<?> declaringClass, Class<?> ... parameterTypes) {
        return MethodDescriptor.ofMethod(declaringClass, INIT, Void.TYPE, (Object[])parameterTypes);
    }

    public static MethodDescriptor ofConstructor(Object declaringClass, Object ... parameterTypes) {
        return MethodDescriptor.ofMethod(declaringClass, INIT, Void.TYPE, parameterTypes);
    }

    public static MethodDescriptor of(MethodInfo methodInfo) {
        return new MethodDescriptor(methodInfo);
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean equals(Object o) {
        return o instanceof MethodDescriptor && this.equals((MethodDescriptor)o);
    }

    public boolean equals(MethodDescriptor o) {
        return o == this || o != null && this.declaringClass.equals(o.declaringClass) && this.name.equals(o.name) && this.descriptor.equals(o.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.declaringClass, this.name, this.descriptor);
    }

    public String toString() {
        return "MethodDescriptor{name='" + this.name + "', returnType='" + this.returnType + "', parameterTypes=" + Arrays.toString(this.parameterTypes) + "}";
    }

    public String getDescriptor() {
        return this.descriptor;
    }
}

