/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.api.Access;
import org.jruby.api.Create;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.AutoPointer;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.CallbackManager;
import org.jruby.ext.ffi.DataConverter;
import org.jruby.ext.ffi.Enums;
import org.jruby.ext.ffi.IOModule;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.NoImplFactory;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.io.FileDescriptorIO;
import org.jruby.runtime.ThreadContext;

public abstract class Factory {
    protected Factory() {
    }

    public static final Factory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Ruby runtime2, RubyModule FFI2) {
        RubyModule rubyModule = FFI2;
        synchronized (rubyModule) {
            ThreadContext context = runtime2.getCurrentContext();
            RubyClass Object2 = Access.objectClass(context);
            RubyClass _Type = FFI2.getClass(context, "Type");
            RubyClass _Struct = FFI2.getClass(context, "Struct");
            RubyClass _AbstractMemory = FFI2.getClass(context, "AbstractMemory");
            RubyClass _Pointer = FFI2.getClass(context, "Pointer");
            RubyModule _DataConverter = DataConverter.createDataConverterModule(context, FFI2);
            if (_Type == null) {
                _Type = Type.createTypeClass(context, FFI2, Object2);
            }
            if (_AbstractMemory == null) {
                _AbstractMemory = AbstractMemory.createAbstractMemoryClass(context, FFI2, Object2);
            }
            if (FFI2.getClass(context, "Buffer") == null) {
                Buffer.createBufferClass(context, FFI2, _AbstractMemory);
            }
            if (_Pointer == null) {
                _Pointer = Pointer.createPointerClass(context, FFI2, _AbstractMemory);
            }
            if (FFI2.getClass(context, "AutoPointer") == null) {
                AutoPointer.createAutoPointerClass(context, FFI2, _Pointer);
            }
            if (FFI2.getClass(context, "MemoryPointer") == null) {
                MemoryPointer.createMemoryPointerClass(context, FFI2, _Pointer);
            }
            if (_Struct == null) {
                _Struct = Struct.createStructClass(context, FFI2);
            }
            if (FFI2.getClass(context, "StructLayout") == null) {
                StructLayout.createStructLayoutClass(context, FFI2, Object2, Access.enumerableModule(context), _Type, _Struct);
            }
            if (FFI2.getClass(context, "StructByValue") == null) {
                StructByValue.createStructByValueClass(context, FFI2, _Type);
            }
            if (FFI2.getClass(context, "AbstractInvoker") == null) {
                AbstractInvoker.createAbstractInvokerClass(context, FFI2, _Pointer);
            }
            if (FFI2.getClass(context, "CallbackInfo") == null) {
                CallbackInfo.createCallbackInfoClass(context, FFI2, _Type);
            }
            if (FFI2.getClass(context, "Enums") == null) {
                Enums.createEnumsClass(context, FFI2, Object2, _DataConverter);
            }
            if (_Type.getClass(context, "Mapped") == null) {
                MappedType.createConverterTypeClass(context, _Type);
            }
            if (FFI2.getClass(context, "FileDescriptorIO") == null) {
                FileDescriptorIO.createFileDescriptorIOClass(context, FFI2, Access.ioClass(context));
            }
            FFI2.defineConstant(context, "TypeDefs", Create.newHash(context));
            Platform.createPlatformModule(context, FFI2);
            IOModule.createIOModule(context, FFI2);
        }
    }

    public abstract MemoryIO allocateDirectMemory(Ruby var1, int var2, boolean var3);

    public abstract MemoryIO allocateDirectMemory(Ruby var1, int var2, int var3, boolean var4);

    public abstract MemoryIO allocateTransientDirectMemory(Ruby var1, int var2, int var3, boolean var4);

    public abstract MemoryIO wrapDirectMemory(Ruby var1, long var2);

    public abstract CallbackManager getCallbackManager();

    public abstract AbstractInvoker newFunction(Ruby var1, Pointer var2, CallbackInfo var3);

    public abstract int sizeOf(NativeType var1);

    public abstract int alignmentOf(NativeType var1);

    private static final class SingletonHolder {
        private static final Factory INSTANCE = SingletonHolder.getInstance();

        private SingletonHolder() {
        }

        private static final Factory getInstance() {
            String providerName = System.getProperty("ffi.factory");
            Factory factory = null;
            ArrayList<Object> providerNames = new ArrayList<Object>();
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            if (providerName != null) {
                providerNames.add(providerName);
            }
            String prefix = Factory.class.getPackage().getName();
            providerNames.add(prefix + ".jffi.Factory");
            for (String string2 : providerNames) {
                try {
                    factory = (Factory)Class.forName(string2, true, Ruby.getClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                catch (Throwable ex) {
                    errors.add(ex);
                }
            }
            if (factory == null) {
                StringBuilder sb = new StringBuilder();
                for (Throwable t : errors) {
                    sb.append(t.getLocalizedMessage()).append('\n');
                }
                factory = new NoImplFactory(sb.toString());
            }
            return factory;
        }
    }
}

