/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.windows;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum Errno implements Constant
{
    EPERM(1L),
    ENOENT(2L),
    ESRCH(3L),
    EINTR(4L),
    EIO(5L),
    ENXIO(6L),
    E2BIG(7L),
    ENOEXEC(8L),
    EBADF(9L),
    ECHILD(10L),
    EDEADLK(36L),
    ENOMEM(12L),
    EACCES(13L),
    EFAULT(14L),
    EBUSY(16L),
    EEXIST(17L),
    EXDEV(18L),
    ENODEV(19L),
    ENOTDIR(20L),
    EISDIR(21L),
    EINVAL(22L),
    ENFILE(23L),
    EMFILE(24L),
    ENOTTY(25L),
    ETXTBSY(139L),
    EFBIG(27L),
    ENOSPC(28L),
    ESPIPE(29L),
    EROFS(30L),
    EMLINK(31L),
    EPIPE(32L),
    EDOM(33L),
    ERANGE(34L),
    EWOULDBLOCK(140L),
    EAGAIN(11L),
    EINPROGRESS(112L),
    EALREADY(103L),
    ENOTSOCK(128L),
    EDESTADDRREQ(109L),
    EMSGSIZE(115L),
    EPROTOTYPE(136L),
    ENOPROTOOPT(123L),
    EPROTONOSUPPORT(135L),
    EOPNOTSUPP(130L),
    EAFNOSUPPORT(102L),
    EADDRINUSE(100L),
    EADDRNOTAVAIL(101L),
    ENETDOWN(116L),
    ENETUNREACH(118L),
    ENETRESET(117L),
    ECONNABORTED(106L),
    ECONNRESET(108L),
    ENOBUFS(119L),
    EISCONN(113L),
    ENOTCONN(126L),
    ETIMEDOUT(138L),
    ECONNREFUSED(107L),
    ELOOP(114L),
    ENAMETOOLONG(38L),
    EHOSTUNREACH(110L),
    ENOTEMPTY(41L),
    ENOLCK(39L),
    ENOSYS(40L),
    EOVERFLOW(132L),
    EIDRM(111L),
    ENOMSG(122L),
    EILSEQ(42L),
    EBADMSG(104L),
    ENODATA(120L),
    ENOLINK(121L),
    ENOSR(124L),
    ENOSTR(125L),
    EPROTO(134L),
    ETIME(137L),
    EDEADLOCK(36L),
    ECANCELED(105L),
    ENOTRECOVERABLE(127L),
    EOWNERDEAD(133L),
    ENOTSUP(129L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 140L;

    private Errno(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map2 = new EnumMap<Errno, String>(Errno.class);
            map2.put(EPERM, "Operation not permitted");
            map2.put(ENOENT, "No such file or directory");
            map2.put(ESRCH, "No such process");
            map2.put(EINTR, "Interrupted function call");
            map2.put(EIO, "Input/output error");
            map2.put(ENXIO, "No such device or address");
            map2.put(E2BIG, "Arg list too long");
            map2.put(ENOEXEC, "Exec format error");
            map2.put(EBADF, "Bad file descriptor");
            map2.put(ECHILD, "No child processes");
            map2.put(EDEADLK, "Resource deadlock avoided");
            map2.put(ENOMEM, "Not enough space");
            map2.put(EACCES, "Permission denied");
            map2.put(EFAULT, "Bad address");
            map2.put(EBUSY, "Resource device");
            map2.put(EEXIST, "File exists");
            map2.put(EXDEV, "Improper link");
            map2.put(ENODEV, "No such device");
            map2.put(ENOTDIR, "Not a directory");
            map2.put(EISDIR, "Is a directory");
            map2.put(EINVAL, "Invalid argument");
            map2.put(ENFILE, "Too many open files in system");
            map2.put(EMFILE, "Too many open files");
            map2.put(ENOTTY, "Inappropriate I/O control operation");
            map2.put(ETXTBSY, "Unknown error");
            map2.put(EFBIG, "File too large");
            map2.put(ENOSPC, "No space left on device");
            map2.put(ESPIPE, "Invalid seek");
            map2.put(EROFS, "Read-only file system");
            map2.put(EMLINK, "Too many links");
            map2.put(EPIPE, "Broken pipe");
            map2.put(EDOM, "Domain error");
            map2.put(ERANGE, "Result too large");
            map2.put(EWOULDBLOCK, "Unknown error");
            map2.put(EAGAIN, "Resource temporarily unavailable");
            map2.put(EINPROGRESS, "Unknown error");
            map2.put(EALREADY, "Unknown error");
            map2.put(ENOTSOCK, "Unknown error");
            map2.put(EDESTADDRREQ, "Unknown error");
            map2.put(EMSGSIZE, "Unknown error");
            map2.put(EPROTOTYPE, "Unknown error");
            map2.put(ENOPROTOOPT, "Unknown error");
            map2.put(EPROTONOSUPPORT, "Unknown error");
            map2.put(EOPNOTSUPP, "Unknown error");
            map2.put(EAFNOSUPPORT, "Unknown error");
            map2.put(EADDRINUSE, "Unknown error");
            map2.put(EADDRNOTAVAIL, "Unknown error");
            map2.put(ENETDOWN, "Unknown error");
            map2.put(ENETUNREACH, "Unknown error");
            map2.put(ENETRESET, "Unknown error");
            map2.put(ECONNABORTED, "Unknown error");
            map2.put(ECONNRESET, "Unknown error");
            map2.put(ENOBUFS, "Unknown error");
            map2.put(EISCONN, "Unknown error");
            map2.put(ENOTCONN, "Unknown error");
            map2.put(ETIMEDOUT, "Unknown error");
            map2.put(ECONNREFUSED, "Unknown error");
            map2.put(ELOOP, "Unknown error");
            map2.put(ENAMETOOLONG, "Filename too long");
            map2.put(EHOSTUNREACH, "Unknown error");
            map2.put(ENOTEMPTY, "Directory not empty");
            map2.put(ENOLCK, "No locks available");
            map2.put(ENOSYS, "Function not implemented");
            map2.put(EOVERFLOW, "Unknown error");
            map2.put(EIDRM, "Unknown error");
            map2.put(ENOMSG, "Unknown error");
            map2.put(EILSEQ, "Illegal byte sequence");
            map2.put(EBADMSG, "Unknown error");
            map2.put(ENODATA, "Unknown error");
            map2.put(ENOLINK, "Unknown error");
            map2.put(ENOSR, "Unknown error");
            map2.put(ENOSTR, "Unknown error");
            map2.put(EPROTO, "Unknown error");
            map2.put(ETIME, "Unknown error");
            map2.put(EDEADLOCK, "Resource deadlock avoided");
            map2.put(ECANCELED, "Unknown error");
            map2.put(ENOTRECOVERABLE, "Unknown error");
            map2.put(EOWNERDEAD, "Unknown error");
            map2.put(ENOTSUP, "Unknown error");
            return map2;
        }
    }
}

