/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class Vector<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public Vector(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector() {
        this(10);
    }

    public Vector(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        this.elementCount = objectArray.length;
        this.elementData = collection.getClass() == ArrayList.class ? objectArray : Arrays.copyOf(objectArray, this.elementCount, Object[].class);
    }

    public synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized void trimToSize() {
        ++this.modCount;
        int n = this.elementData.length;
        if (this.elementCount < n) {
            this.elementData = Arrays.copyOf(this.elementData, this.elementCount);
        }
    }

    public synchronized void ensureCapacity(int n) {
        if (n > 0) {
            ++this.modCount;
            this.ensureCapacityHelper(n);
        }
    }

    private void ensureCapacityHelper(int n) {
        if (n - this.elementData.length > 0) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.elementData.length;
        int n3 = n2 + (this.capacityIncrement > 0 ? this.capacityIncrement : n2);
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = Vector.hugeCapacity(n);
        }
        this.elementData = Arrays.copyOf(this.elementData, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public synchronized void setSize(int n) {
        ++this.modCount;
        if (n > this.elementCount) {
            this.ensureCapacityHelper(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration<E> elements() {
        return new Enumeration<E>(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < Vector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E nextElement() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    if (this.count < Vector.this.elementCount) {
                        return Vector.this.elementData(this.count++);
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int n) {
        if (object == null) {
            for (int i = n; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object object, int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized E elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        return this.elementData(n);
    }

    public synchronized E firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData(0);
    }

    public synchronized E lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData(this.elementCount - 1);
    }

    public synchronized void setElementAt(E e, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = e;
    }

    public synchronized void removeElementAt(int n) {
        ++this.modCount;
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public synchronized void insertElementAt(E e, int n) {
        ++this.modCount;
        if (n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = e;
        ++this.elementCount;
    }

    public synchronized void addElement(E e) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = e;
    }

    public synchronized boolean removeElement(Object object) {
        ++this.modCount;
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        ++this.modCount;
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = Arrays.copyOf(this.elementData, this.elementCount);
            vector.modCount = 0;
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    @Override
    public synchronized Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.elementCount);
    }

    @Override
    public synchronized <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.elementCount) {
            return Arrays.copyOf(this.elementData, this.elementCount, TArray.getClass());
        }
        System.arraycopy(this.elementData, 0, TArray, 0, this.elementCount);
        if (TArray.length > this.elementCount) {
            TArray[this.elementCount] = null;
        }
        return TArray;
    }

    E elementData(int n) {
        return (E)this.elementData[n];
    }

    @Override
    public synchronized E get(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.elementData(n);
    }

    @Override
    public synchronized E set(int n, E e) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        E e2 = this.elementData(n);
        this.elementData[n] = e;
        return e2;
    }

    @Override
    public synchronized boolean add(E e) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = e;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    @Override
    public void add(int n, E e) {
        this.insertElementAt(e, n);
    }

    @Override
    public synchronized E remove(int n) {
        ++this.modCount;
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        E e = this.elementData(n);
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.elementCount] = null;
        return e;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        return super.containsAll(collection);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        ++this.modCount;
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        this.ensureCapacityHelper(this.elementCount + n);
        System.arraycopy(objectArray, 0, this.elementData, this.elementCount, n);
        this.elementCount += n;
        return n != 0;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        return super.removeAll(collection);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        return super.retainAll(collection);
    }

    @Override
    public synchronized boolean addAll(int n, Collection<? extends E> collection) {
        ++this.modCount;
        if (n < 0 || n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacityHelper(this.elementCount + n2);
        int n3 = this.elementCount - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        System.arraycopy(objectArray, 0, this.elementData, n, n2);
        this.elementCount += n2;
        return n2 != 0;
    }

    @Override
    public synchronized boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized String toString() {
        return super.toString();
    }

    @Override
    public synchronized List<E> subList(int n, int n2) {
        return Collections.synchronizedList(super.subList(n, n2), this);
    }

    @Override
    protected synchronized void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.elementCount - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.elementCount - (n2 - n);
        while (this.elementCount != n4) {
            this.elementData[--this.elementCount] = null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        int n = getField.get("elementCount", 0);
        Object[] objectArray = (Object[])getField.get("elementData", null);
        if (n < 0 || objectArray == null || n > objectArray.length) {
            throw new StreamCorruptedException("Inconsistent vector internals");
        }
        this.elementCount = n;
        this.elementData = (Object[])objectArray.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray;
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        Vector vector = this;
        synchronized (vector) {
            putField.put("capacityIncrement", this.capacityIncrement);
            putField.put("elementCount", this.elementCount);
            objectArray = (Object[])this.elementData.clone();
        }
        putField.put("elementData", objectArray);
        objectOutputStream.writeFields();
    }

    @Override
    public synchronized ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this.elementCount) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new ListItr(n);
    }

    @Override
    public synchronized ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public synchronized void forEach(Consumer<? super E> consumer) {
        Objects.requireNonNull(consumer);
        int n = this.modCount;
        Object[] objectArray = this.elementData;
        int n2 = this.elementCount;
        for (int i = 0; this.modCount == n && i < n2; ++i) {
            consumer.accept(objectArray[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public synchronized boolean removeIf(Predicate<? super E> predicate) {
        int n;
        Objects.requireNonNull(predicate);
        int n2 = 0;
        int n3 = this.elementCount;
        BitSet bitSet = new BitSet(n3);
        int n4 = this.modCount;
        for (n = 0; this.modCount == n4 && n < n3; ++n) {
            Object object = this.elementData[n];
            if (!predicate.test(object)) continue;
            bitSet.set(n);
            ++n2;
        }
        if (this.modCount != n4) {
            throw new ConcurrentModificationException();
        }
        int n5 = n = n2 > 0 ? 1 : 0;
        if (n != 0) {
            int n6 = n3 - n2;
            int n7 = 0;
            for (int i = 0; n7 < n3 && i < n6; ++n7, ++i) {
                n7 = bitSet.nextClearBit(n7);
                this.elementData[i] = this.elementData[n7];
            }
            for (n7 = n6; n7 < n3; ++n7) {
                this.elementData[n7] = null;
            }
            this.elementCount = n6;
            if (this.modCount != n4) {
                throw new ConcurrentModificationException();
            }
            ++this.modCount;
        }
        return n != 0;
    }

    @Override
    public synchronized void replaceAll(UnaryOperator<E> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        int n = this.modCount;
        int n2 = this.elementCount;
        for (int i = 0; this.modCount == n && i < n2; ++i) {
            this.elementData[i] = unaryOperator.apply(this.elementData[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    @Override
    public synchronized void sort(Comparator<? super E> comparator) {
        int n = this.modCount;
        Arrays.sort(this.elementData, 0, this.elementCount, comparator);
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    @Override
    public Spliterator<E> spliterator() {
        return new VectorSpliterator(this, null, 0, -1, 0);
    }

    static final class VectorSpliterator<E>
    implements Spliterator<E> {
        private final Vector<E> list;
        private Object[] array;
        private int index;
        private int fence;
        private int expectedModCount;

        VectorSpliterator(Vector<E> vector, Object[] objectArray, int n, int n2, int n3) {
            this.list = vector;
            this.array = objectArray;
            this.index = n;
            this.fence = n2;
            this.expectedModCount = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getFence() {
            int n = this.fence;
            if (n < 0) {
                Vector<E> vector = this.list;
                synchronized (vector) {
                    this.array = this.list.elementData;
                    this.expectedModCount = this.list.modCount;
                    n = this.fence = this.list.elementCount;
                }
            }
            return n;
        }

        @Override
        public Spliterator<E> trySplit() {
            VectorSpliterator<E> vectorSpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1;
            if (n >= n3) {
                vectorSpliterator = null;
            } else {
                this.index = n3;
                VectorSpliterator<E> vectorSpliterator2 = new VectorSpliterator<E>(this.list, this.array, n, this.index, this.expectedModCount);
                vectorSpliterator = vectorSpliterator2;
            }
            return vectorSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            int n = this.index;
            if (this.getFence() > n) {
                this.index = n + 1;
                consumer.accept(this.array[n]);
                if (this.list.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Vector<E> vector = this.list;
            if (vector != null) {
                int n;
                Object[] objectArray;
                int n2 = this.fence;
                if (n2 < 0) {
                    Vector<E> vector2 = vector;
                    synchronized (vector2) {
                        this.expectedModCount = vector.modCount;
                        this.array = vector.elementData;
                        objectArray = vector.elementData;
                        n2 = this.fence = vector.elementCount;
                    }
                } else {
                    objectArray = this.array;
                }
                if (objectArray != null && (n = this.index) >= 0 && (this.index = n2) <= objectArray.length) {
                    while (n < n2) {
                        consumer.accept(objectArray[n++]);
                    }
                    if (vector.modCount == this.expectedModCount) {
                        return;
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    final class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int n) {
            this.cursor = n;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E previous() {
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                int n = this.cursor - 1;
                if (n < 0) {
                    throw new NoSuchElementException();
                }
                this.cursor = n;
                this.lastRet = n;
                return Vector.this.elementData(this.lastRet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E e) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.set(this.lastRet, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(E e) {
            int n = this.cursor;
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.add(n, e);
                this.expectedModCount = Vector.this.modCount;
            }
            this.cursor = n + 1;
            this.lastRet = -1;
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = Vector.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != Vector.this.elementCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                int n = this.cursor;
                if (n >= Vector.this.elementCount) {
                    throw new NoSuchElementException();
                }
                this.cursor = n + 1;
                this.lastRet = n;
                return Vector.this.elementData(this.lastRet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.remove(this.lastRet);
                this.expectedModCount = Vector.this.modCount;
            }
            this.cursor = this.lastRet;
            this.lastRet = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            Objects.requireNonNull(consumer);
            Vector vector = Vector.this;
            synchronized (vector) {
                int n = Vector.this.elementCount;
                int n2 = this.cursor;
                if (n2 >= n) {
                    return;
                }
                Object[] objectArray = Vector.this.elementData;
                if (n2 >= objectArray.length) {
                    throw new ConcurrentModificationException();
                }
                while (n2 != n && Vector.this.modCount == this.expectedModCount) {
                    consumer.accept(objectArray[n2++]);
                }
                this.cursor = n2;
                this.lastRet = n2 - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (Vector.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

