/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.V3;

class Slice {
    final P4 leftPlane = new P4();
    final P4 middle = new P4();
    final P4 rightPlane = new P4();
    float angleXY;
    float anglefromZ;
    float position;
    float thickness;
    final P3 boundBoxNegCorner = new P3();
    final P3 boundBoxPosCorner = new P3();
    final P3 boundBoxCenter = new P3();
    float diagonal;

    Slice() {
    }

    static void makePlane(float length, float angleXY, float anglefromZ, P4 result) {
        result.set4((float)(Math.cos(angleXY) * Math.sin(anglefromZ)), (float)(Math.sin(angleXY) * Math.sin(anglefromZ)), (float)Math.cos(anglefromZ), -length);
    }

    void setSlice(float angleXY, float anglefromZ, float position, float thickness, P3 boundBoxCenter, V3 boundBoxVec, boolean useMolecular) {
        if (angleXY >= 0.0f && (double)angleXY < Math.PI) {
            this.angleXY = angleXY;
        } else {
            float fix = (float)Math.floor((double)angleXY / Math.PI);
            this.angleXY = (float)((double)angleXY - (double)fix * Math.PI);
        }
        if (anglefromZ >= 0.0f && (double)anglefromZ < Math.PI) {
            this.anglefromZ = anglefromZ;
        } else {
            double fix = Math.floor((double)anglefromZ / Math.PI);
            this.anglefromZ = (float)((double)anglefromZ - fix * Math.PI);
        }
        this.position = position;
        this.thickness = thickness;
        this.boundBoxCenter.setT(boundBoxCenter);
        this.boundBoxNegCorner.sub2(boundBoxCenter, boundBoxVec);
        this.boundBoxPosCorner.add2(boundBoxCenter, boundBoxVec);
        this.diagonal = this.boundBoxPosCorner.distance(this.boundBoxNegCorner);
        Slice.makePlane(position, angleXY, anglefromZ, this.middle);
        if (!useMolecular) {
            P3 pt = P3.new3(this.middle.x, this.middle.y, this.middle.z);
            pt.scaleAdd2(-this.middle.w, pt, boundBoxCenter);
            Measure.getPlaneThroughPoint(pt, V3.new3(this.middle.x, this.middle.y, this.middle.z), this.middle);
        }
        this.leftPlane.set4(this.middle.x, this.middle.y, this.middle.z, this.middle.w);
        this.leftPlane.w += thickness / 2.0f;
        this.rightPlane.set4(this.middle.x, this.middle.y, this.middle.z, this.middle.w);
        this.rightPlane.w -= thickness / 2.0f;
        System.out.println(thickness + " left:" + this.leftPlane + " right:" + this.rightPlane);
    }

    Slice getSlice() {
        return this;
    }

    P4 getMiddle() {
        return this.middle;
    }
}

