/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Produce a binary image where foreground is the regional minima of the
input image.


Regional minima are flat zones surrounded by pixels of greater value.

If the input image is constant, the entire image can be considered as
a minima or not. The SetFlatIsMinima() method let the user choose which behavior to use.

This class was contributed to the Insight Journal by
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France. https://doi.org/10.54294/hva3gz

See:
 RegionalMaximaImageFilter

 ValuedRegionalMinimaImageFilter

 HConcaveImageFilter

 itk::simple::RegionalMinima for the procedural interface

 itk::RegionalMinimaImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkRegionalMinimaImageFilter.h
*/
public class RegionalMinimaImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected RegionalMinimaImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.RegionalMinimaImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RegionalMinimaImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RegionalMinimaImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::RegionalMinimaImageFilter::~RegionalMinimaImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_RegionalMinimaImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::RegionalMinimaImageFilter::RegionalMinimaImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  RegionalMinimaImageFilter() {
    this(SimpleITKJNI.new_RegionalMinimaImageFilter(), true);
  }

  /**
Self&amp; itk::simple::RegionalMinimaImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.RegionalMinimaImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::RegionalMinimaImageFilter::GetBackgroundValue() const

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.RegionalMinimaImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RegionalMinimaImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the value in the output image to consider as "foreground".
Defaults to maximum value of PixelType.

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.RegionalMinimaImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::RegionalMinimaImageFilter::GetForegroundValue() const

Set/Get the value in the output image to consider as "foreground".
Defaults to maximum value of PixelType.

*/
public  double getForegroundValue() {
    return SimpleITKJNI.RegionalMinimaImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RegionalMinimaImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.RegionalMinimaImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::RegionalMinimaImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.RegionalMinimaImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RegionalMinimaImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.RegionalMinimaImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::RegionalMinimaImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.RegionalMinimaImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RegionalMinimaImageFilter::SetFlatIsMinima(bool FlatIsMinima)

Set/Get whether a flat image must be considered as a minima or not.
Defaults to true.

*/
public  void setFlatIsMinima(boolean FlatIsMinima) {
    SimpleITKJNI.RegionalMinimaImageFilter_setFlatIsMinima(swigCPtr, this, FlatIsMinima);
  }

  /**
Self&amp; itk::simple::RegionalMinimaImageFilter::FlatIsMinimaOn()

Set the value of FlatIsMinima to true or false respectfully.

*/
public  void flatIsMinimaOn() {
    SimpleITKJNI.RegionalMinimaImageFilter_flatIsMinimaOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RegionalMinimaImageFilter::FlatIsMinimaOff()
*/
public  void flatIsMinimaOff() {
    SimpleITKJNI.RegionalMinimaImageFilter_flatIsMinimaOff(swigCPtr, this);
  }

  /**
bool itk::simple::RegionalMinimaImageFilter::GetFlatIsMinima() const

Set/Get whether a flat image must be considered as a minima or not.
Defaults to true.

*/
public  boolean getFlatIsMinima() {
    return SimpleITKJNI.RegionalMinimaImageFilter_getFlatIsMinima(swigCPtr, this);
  }

  /**
std::string itk::simple::RegionalMinimaImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.RegionalMinimaImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::RegionalMinimaImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.RegionalMinimaImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::RegionalMinimaImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.RegionalMinimaImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
