/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.Cancellable;
import org.apache.sshd.common.future.DefaultCancelFuture;
import org.apache.sshd.common.future.DefaultVerifiableSshFuture;
import org.apache.sshd.common.future.SshFuture;

public abstract class DefaultCancellableSshFuture<T extends SshFuture<T>>
extends DefaultVerifiableSshFuture<T>
implements Cancellable {
    protected DefaultCancellableSshFuture(Object id, Object lock) {
        super(id, lock);
    }

    @Override
    public boolean isCanceled() {
        return this.getValue() instanceof CancelFuture;
    }

    @Override
    protected CancelFuture createCancellation() {
        return new DefaultCancelFuture(this.getId());
    }

    @Override
    public CancelFuture cancel() {
        CancelFuture cancellation = this.createCancellation();
        if (cancellation == null) {
            return this.getCancellation();
        }
        cancellation.setBackTrace(new CancellationException("Programmatically canceled"));
        this.setValue(cancellation);
        return this.getCancellation();
    }

    @Override
    public CancelFuture getCancellation() {
        Object v = this.getValue();
        return v instanceof CancelFuture ? (CancelFuture)v : null;
    }

    @Override
    public Throwable getException() {
        Object v = this.getValue();
        return v instanceof Throwable ? (Throwable)v : null;
    }

    @Override
    public void setException(Throwable exception) {
        CancelFuture cancellation;
        this.setValue(Objects.requireNonNull(exception, "No exception provided"));
        if (this.getException() == null && (cancellation = this.getCancellation()) != null) {
            cancellation.setCanceled(exception);
        }
    }
}

