/**
 * SECTION:query
 * @short_description: A contact query.
 * 
 * <para>If any properties of the query change such that matches may change, the <link linkend="GObject-notify"><type>"notify"</type></link> signal will be emitted, potentially without a detail string. Views which are using this query should re-evaluate their matches on receiving this signal.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="FolksSearchView"><type>FolksSearchView</type></link>
 *
 * Since: 0.11.0
 */
/**
 * FOLKS_TYPE_QUERY:
 * 
 * The type for <link linkend="FolksQuery"><type>FolksQuery</type></link>.
 */
/**
 * folks_query_is_match:
 * @self: the <link linkend="FolksQuery"><type>FolksQuery</type></link> instance
 * @individual: (in): &nbsp;.  <para>an <link linkend="FolksIndividual"><type>FolksIndividual</type></link> to match against </para>
 * 
 * Determines whether a given <link linkend="FolksIndividual"><type>FolksIndividual</type></link> matches this query.
 * 
 * <para>This returns a match strength, which is on an arbitrary scale which is not part of libfolks’ public API. These strengths should not be stored by user applications, or examined numerically — they should only be used for pairwise strength comparisons.</para><para>This function is intended to be used in the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> implementation only. Use <link linkend="FolksSearchView--individuals"><type>"individuals"</type></link> to retrieve search results.</para>
 * 
 * Returns: <para>a positive integer if the individual matches this query, or zero if they do not match; higher numbers indicate a better match </para>
 *
 * Since: 0.11.0
 */
/**
 * FOLKS_QUERY_MATCH_FIELDS_NAMES:
 * 
 * Set of name match fields.
 * 
 * <para>These are ordered approximately by descending match likeliness to speed up calls to <link linkend="folks-query-is-match"><function>folks_query_is_match()</function></link> when used as-is.</para>
 *
 * Since: 0.11.0
 */
/**
 * FOLKS_QUERY_MATCH_FIELDS_ADDRESSES:
 * 
 * Set of address (email, IM, postal, phone number, etc.) match fields.
 * 
 * <para>These are ordered approximately by descending match likeliness to speed up calls to <link linkend="folks-query-is-match"><function>folks_query_is_match()</function></link> when used as-is.</para>
 *
 * Since: 0.11.0
 */
/**
 * FOLKS_QUERY_MATCH_FIELDS_MISC:
 * 
 * Set of miscellaneous match fields.
 * 
 * <para>These are ordered approximately by descending match likeliness to speed up calls to <link linkend="folks-query-is-match"><function>folks_query_is_match()</function></link> when used as-is.</para>
 *
 * Since: 0.11.0
 */
/**
 * FolksQuery:match-fields:
 * @result_length1: return location for the length of the property's value
 * 
 * The names of the fields to match within
 * 
 * <para>The names of valid fields are available via <link linkend="folks-persona-store-detail-key"><function>folks_persona_store_detail_key()</function></link>.</para><para>The ordering of the fields determines the order they are checked for matches, which can have performance implications (these should ideally be ordered from most- to least-likely to match).</para><para>Also note that more fields (particularly rarely-matched fields) will negatively impact performance, so only include important fields.</para><para>Default value is <link linkend="FOLKS-QUERY-MATCH-FIELDS-NAMES:CAPS"><literal>FOLKS_QUERY_MATCH_FIELDS_NAMES</literal></link>.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="FolksPersonaDetail"><type>FolksPersonaDetail</type></link>, <link linkend="folks-persona-store-detail-key"><function>folks_persona_store_detail_key()</function></link>, <link linkend="FOLKS-QUERY-MATCH-FIELDS-NAMES:CAPS"><literal>FOLKS_QUERY_MATCH_FIELDS_NAMES</literal></link>, <link linkend="FOLKS-QUERY-MATCH-FIELDS-ADDRESSES:CAPS"><literal>FOLKS_QUERY_MATCH_FIELDS_ADDRESSES</literal></link>, <link linkend="FOLKS-QUERY-MATCH-FIELDS-MISC:CAPS"><literal>FOLKS_QUERY_MATCH_FIELDS_MISC</literal></link>
 *
 * Since: 0.11.0
 */
/**
 * folks_query_get_match_fields:
 * @self: the <link linkend="FolksQuery"><type>FolksQuery</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksQuery--match-fields"><type>"match-fields"</type></link> property.
 * 
 * The names of the fields to match within
 * 
 * <para>The names of valid fields are available via <link linkend="folks-persona-store-detail-key"><function>folks_persona_store_detail_key()</function></link>.</para><para>The ordering of the fields determines the order they are checked for matches, which can have performance implications (these should ideally be ordered from most- to least-likely to match).</para><para>Also note that more fields (particularly rarely-matched fields) will negatively impact performance, so only include important fields.</para><para>Default value is <link linkend="FOLKS-QUERY-MATCH-FIELDS-NAMES:CAPS"><literal>FOLKS_QUERY_MATCH_FIELDS_NAMES</literal></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksQuery--match-fields"><type>"match-fields"</type></link> property
 *
 * Since: 0.11.0
 */
/**
 * FolksQuery:
 * 
 * A contact query.
 * 
 * <para>If any properties of the query change such that matches may change, the <link linkend="GObject-notify"><type>"notify"</type></link> signal will be emitted, potentially without a detail string. Views which are using this query should re-evaluate their matches on receiving this signal.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="FolksSearchView"><type>FolksSearchView</type></link>
 *
 * Since: 0.11.0
 */
/**
 * FolksQueryClass:
 * @is_match: virtual method called by <link linkend="folks-query-is-match"><function>folks_query_is_match()</function></link>
 * @get_match_fields: getter method for the abstract property <link linkend="FolksQuery--match-fields"><type>"match-fields"</type></link>
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-QUERY:CAPS"><literal>FOLKS_TYPE_QUERY</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
