/*
 *
 *  Copyright (C) 2025, Open Connections GmbH
 *  All rights reserved.  See COPYRIGHT file for details.
 *
 *  This software and supporting documentation are maintained by
 *
 *    OFFIS e.V.
 *    R&D Division Health
 *    Escherweg 2
 *    D-26121 Oldenburg, Germany
 *
 *
 *  Module: dcmiod
 *
 *  Author: Michael Onken
 *
 *  Purpose: Example ICC profile data for sRGB color space
 *
 */

#ifndef ICCEXAMPLE_H
#define ICCEXAMPLE_H

// The given ICC profile is a small valid ICC profile for sRGB color space that can be used
// in case no other profile is available. It is based on the example profile given in
// https://github.com/saucecontrol/Compact-ICC-Profiles (sRGB-v2-magic.icc using 182-Point Curve)

const unsigned char DCMTK_SRGB_ICC_SAMPLE[] = {
  0x00, 0x00, 0x02, 0xe0, 0x6c, 0x63, 0x6d, 0x73, 0x02, 0x10, 0x00, 0x00,
  0x73, 0x63, 0x6e, 0x72, 0x52, 0x47, 0x42, 0x20, 0x58, 0x59, 0x5a, 0x20,
  0x07, 0xe2, 0x00, 0x03, 0x00, 0x14, 0x00, 0x09, 0x00, 0x0e, 0x00, 0x1d,
  0x61, 0x63, 0x73, 0x70, 0x4d, 0x53, 0x46, 0x54, 0x00, 0x00, 0x00, 0x00,
  0x73, 0x61, 0x77, 0x73, 0x63, 0x74, 0x72, 0x6c, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xd6,
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xd3, 0x2d, 0x68, 0x61, 0x6e, 0x64,
  0x93, 0xb2, 0x34, 0xa9, 0x0e, 0xb0, 0x22, 0x8a, 0x98, 0xfd, 0x9a, 0xaf,
  0xa3, 0x67, 0x89, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
  0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x5f,
  0x63, 0x70, 0x72, 0x74, 0x00, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x0c,
  0x77, 0x74, 0x70, 0x74, 0x00, 0x00, 0x01, 0x18, 0x00, 0x00, 0x00, 0x14,
  0x72, 0x58, 0x59, 0x5a, 0x00, 0x00, 0x01, 0x2c, 0x00, 0x00, 0x00, 0x14,
  0x67, 0x58, 0x59, 0x5a, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x14,
  0x62, 0x58, 0x59, 0x5a, 0x00, 0x00, 0x01, 0x54, 0x00, 0x00, 0x00, 0x14,
  0x72, 0x54, 0x52, 0x43, 0x00, 0x00, 0x01, 0x68, 0x00, 0x00, 0x01, 0x78,
  0x67, 0x54, 0x52, 0x43, 0x00, 0x00, 0x01, 0x68, 0x00, 0x00, 0x01, 0x78,
  0x62, 0x54, 0x52, 0x43, 0x00, 0x00, 0x01, 0x68, 0x00, 0x00, 0x01, 0x78,
  0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x73, 0x52, 0x47, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x74, 0x65, 0x78, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x43, 0x43, 0x30, 0x00, 0x58, 0x59, 0x5a, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xf3, 0x54, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x16, 0xc9,
  0x58, 0x59, 0x5a, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xa0,
  0x00, 0x00, 0x38, 0xf2, 0x00, 0x00, 0x03, 0x8f, 0x58, 0x59, 0x5a, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x96, 0x00, 0x00, 0xb7, 0x89,
  0x00, 0x00, 0x18, 0xda, 0x58, 0x59, 0x5a, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x24, 0xa0, 0x00, 0x00, 0x0f, 0x85, 0x00, 0x00, 0xb6, 0xc4,
  0x63, 0x75, 0x72, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6,
  0x00, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x54, 0x00, 0x70, 0x00, 0x8c,
  0x00, 0xa8, 0x00, 0xc4, 0x00, 0xe1, 0x01, 0x00, 0x01, 0x22, 0x01, 0x46,
  0x01, 0x6d, 0x01, 0x95, 0x01, 0xc1, 0x01, 0xf0, 0x02, 0x20, 0x02, 0x55,
  0x02, 0x8b, 0x02, 0xc4, 0x03, 0x01, 0x03, 0x3f, 0x03, 0x82, 0x03, 0xc6,
  0x04, 0x0e, 0x04, 0x59, 0x04, 0xa7, 0x04, 0xf9, 0x05, 0x4c, 0x05, 0xa4,
  0x05, 0xfe, 0x06, 0x5c, 0x06, 0xbe, 0x07, 0x21, 0x07, 0x8a, 0x07, 0xf4,
  0x08, 0x63, 0x08, 0xd5, 0x09, 0x49, 0x09, 0xc3, 0x0a, 0x3f, 0x0a, 0xbf,
  0x0b, 0x42, 0x0b, 0xc9, 0x0c, 0x54, 0x0c, 0xe1, 0x0d, 0x74, 0x0e, 0x09,
  0x0e, 0xa2, 0x0f, 0x40, 0x0f, 0xe0, 0x10, 0x85, 0x11, 0x2d, 0x11, 0xda,
  0x12, 0x8a, 0x13, 0x3e, 0x13, 0xf6, 0x14, 0xb2, 0x15, 0x71, 0x16, 0x36,
  0x16, 0xfd, 0x17, 0xca, 0x18, 0x99, 0x19, 0x6e, 0x1a, 0x46, 0x1b, 0x22,
  0x1c, 0x03, 0x1c, 0xe7, 0x1d, 0xd0, 0x1e, 0xbd, 0x1f, 0xae, 0x20, 0xa4,
  0x21, 0x9e, 0x22, 0x9c, 0x23, 0x9f, 0x24, 0xa5, 0x25, 0xb1, 0x26, 0xc0,
  0x27, 0xd5, 0x28, 0xed, 0x2a, 0x0a, 0x2b, 0x2b, 0x2c, 0x51, 0x2d, 0x7c,
  0x2e, 0xaa, 0x2f, 0xde, 0x31, 0x16, 0x32, 0x52, 0x33, 0x94, 0x34, 0xd9,
  0x36, 0x24, 0x37, 0x73, 0x38, 0xc6, 0x3a, 0x20, 0x3b, 0x7c, 0x3c, 0xdf,
  0x3e, 0x45, 0x3f, 0xb0, 0x41, 0x21, 0x42, 0x96, 0x44, 0x10, 0x45, 0x8f,
  0x47, 0x12, 0x48, 0x9b, 0x4a, 0x28, 0x4b, 0xbb, 0x4d, 0x51, 0x4e, 0xee,
  0x50, 0x8f, 0x52, 0x35, 0x53, 0xe0, 0x55, 0x90, 0x57, 0x45, 0x59, 0x00,
  0x5a, 0xbe, 0x5c, 0x84, 0x5e, 0x4c, 0x60, 0x1b, 0x61, 0xef, 0x63, 0xc7,
  0x65, 0xa6, 0x67, 0x89, 0x69, 0x71, 0x6b, 0x5f, 0x6d, 0x51, 0x6f, 0x4a,
  0x71, 0x46, 0x73, 0x4a, 0x75, 0x51, 0x77, 0x5e, 0x79, 0x71, 0x7b, 0x88,
  0x7d, 0xa6, 0x7f, 0xc8, 0x81, 0xf0, 0x84, 0x1e, 0x86, 0x50, 0x88, 0x89,
  0x8a, 0xc5, 0x8d, 0x09, 0x8f, 0x51, 0x91, 0x9f, 0x93, 0xf3, 0x96, 0x4b,
  0x98, 0xab, 0x9b, 0x0e, 0x9d, 0x78, 0x9f, 0xe7, 0xa2, 0x5b, 0xa4, 0xd6,
  0xa7, 0x56, 0xa9, 0xdb, 0xac, 0x67, 0xae, 0xf7, 0xb1, 0x8f, 0xb4, 0x2a,
  0xb6, 0xcc, 0xb9, 0x74, 0xbc, 0x21, 0xbe, 0xd5, 0xc1, 0x8d, 0xc4, 0x4c,
  0xc7, 0x10, 0xc9, 0xda, 0xcc, 0xab, 0xcf, 0x7f, 0xd2, 0x5c, 0xd5, 0x3d,
  0xd8, 0x24, 0xdb, 0x12, 0xde, 0x04, 0xe0, 0xfe, 0xe3, 0xfc, 0xe7, 0x01,
  0xea, 0x0c, 0xed, 0x1c, 0xf0, 0x34, 0xf3, 0x50, 0xf6, 0x73, 0xf9, 0x9b,
  0xfc, 0xca, 0xff, 0xff
};

unsigned int DCMTK_SRGB_ICC_SAMPLE_LEN = 736;

#endif // ICCEXAMPLE_H
