/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AltibaseSequence
extends GenericSequence
implements DBPScriptObject {
    private BigDecimal lastValue;
    private BigDecimal minValue;
    private BigDecimal maxValue;
    private BigDecimal incrementBy;
    private BigDecimal cacheSize;
    private BigDecimal startWith;
    private boolean flagCycle;
    private String source;

    public AltibaseSequence(GenericStructContainer container, String name) {
        super(container, name);
        this.startWith = new BigDecimal(1);
        this.minValue = new BigDecimal(1);
        this.maxValue = new BigDecimal(0x7FFFFFFFFFFFFFFEL);
        this.incrementBy = new BigDecimal(1);
        this.cacheSize = new BigDecimal(20);
        this.flagCycle = true;
    }

    public AltibaseSequence(GenericStructContainer container, JDBCResultSet dbResult) {
        super(container, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME"), "", (Number)0, (Number)0, (Number)0, (Number)0);
        this.lastValue = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"CURRENT_SEQ");
        this.startWith = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"START_SEQ");
        this.minValue = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"MIN_SEQ");
        this.maxValue = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"MAX_SEQ");
        this.incrementBy = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"INCREMENT_SEQ");
        this.cacheSize = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"CACHE_SIZE");
        this.flagCycle = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_CYCLE", (String)"YES");
    }

    @Property(viewable=true, order=2)
    public BigDecimal getLastValue() {
        if (this.lastValue == null) {
            return this.startWith;
        }
        return this.lastValue;
    }

    public void setLastValue(BigDecimal lastValue) {
        this.lastValue = lastValue;
    }

    @Property(viewable=true, editable=true, updatable=true, order=3)
    public BigDecimal getStartWith() {
        return this.startWith;
    }

    @Property(viewable=true, editable=true, updatable=true, order=4)
    public BigDecimal getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(BigDecimal incrementBy) {
        this.incrementBy = incrementBy;
    }

    @Property(viewable=true, editable=true, updatable=true, order=5)
    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    @Property(viewable=true, editable=true, updatable=true, order=6)
    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    @Property(viewable=true, editable=true, updatable=true, order=7)
    public BigDecimal getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(BigDecimal cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Property(viewable=true, editable=true, updatable=true, order=8)
    public boolean getCycle() {
        return this.flagCycle;
    }

    public void setCycle(boolean flagCycle) {
        this.flagCycle = flagCycle;
    }

    public boolean isCycle() {
        return this.flagCycle;
    }

    @Property(viewable=false, hidden=true, order=10)
    public String getDescription() {
        return null;
    }

    public String buildStatement(boolean forUpdate) {
        StringBuilder sb = new StringBuilder();
        if (forUpdate) {
            sb.append("ALTER SEQUENCE ");
        } else {
            sb.append("CREATE SEQUENCE ");
        }
        sb.append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
        if (!forUpdate && this.getStartWith() != null) {
            sb.append("START WITH ").append(this.getStartWith()).append(" ");
        }
        if (this.getIncrementBy() != null) {
            sb.append("INCREMENT BY ").append(this.getIncrementBy()).append(" ");
        }
        if (this.getMinValue() != null) {
            sb.append("MINVALUE ").append(this.getMinValue()).append(" ");
        }
        if (this.getMaxValue() != null) {
            sb.append("MAXVALUE ").append(this.getMaxValue()).append(" ");
        }
        if (this.getCacheSize().compareTo(BigDecimal.ZERO) > 0) {
            sb.append("CACHE ").append(this.getCacheSize()).append(" ");
        } else {
            sb.append("NOCACHE ");
        }
        if (this.isCycle()) {
            sb.append("CYCLE");
        } else {
            sb.append("NOCYCLE");
        }
        sb.append(";");
        return sb.toString();
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.source == null) {
            this.source = this.buildStatement(false);
        }
        return this.source;
    }
}

