/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.security;

import java.sql.ResultSet;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolRole;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ExasolRoleGrant
implements DBAPrivilege {
    private Boolean adminOption;
    private String role;
    private ExasolDataSource dataSource;
    private String grantee;

    public ExasolRoleGrant(ExasolDataSource dataSource, ResultSet resultSet) {
        this.role = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ROLE_NAME");
        this.grantee = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTEE");
        this.dataSource = dataSource;
        this.adminOption = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"ADMIN_OPTION");
    }

    @Property(viewable=true, order=10)
    public ExasolRole getRole(DBRProgressMonitor monitor) throws DBException {
        return this.dataSource.getRole(monitor, this.role);
    }

    @Property(viewable=true, order=20)
    public Boolean getAdminOption() {
        return this.adminOption;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public String getName() {
        return this.grantee + "|" + this.role;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public boolean isPersisted() {
        return false;
    }
}

