﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/eventbridge/EventBridge_EXPORTS.h>
#include <aws/eventbridge/model/PutEventsResultEntry.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EventBridge {
namespace Model {
class PutEventsResult {
 public:
  AWS_EVENTBRIDGE_API PutEventsResult() = default;
  AWS_EVENTBRIDGE_API PutEventsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_EVENTBRIDGE_API PutEventsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The number of failed entries.</p>
   */
  inline int GetFailedEntryCount() const { return m_failedEntryCount; }
  inline void SetFailedEntryCount(int value) {
    m_failedEntryCountHasBeenSet = true;
    m_failedEntryCount = value;
  }
  inline PutEventsResult& WithFailedEntryCount(int value) {
    SetFailedEntryCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The successfully and unsuccessfully ingested events results. If the ingestion
   * was successful, the entry has the event ID in it. Otherwise, you can use the
   * error code and error message to identify the problem with the entry.</p> <p>For
   * each record, the index of the response element is the same as the index in the
   * request array.</p>
   */
  inline const Aws::Vector<PutEventsResultEntry>& GetEntries() const { return m_entries; }
  template <typename EntriesT = Aws::Vector<PutEventsResultEntry>>
  void SetEntries(EntriesT&& value) {
    m_entriesHasBeenSet = true;
    m_entries = std::forward<EntriesT>(value);
  }
  template <typename EntriesT = Aws::Vector<PutEventsResultEntry>>
  PutEventsResult& WithEntries(EntriesT&& value) {
    SetEntries(std::forward<EntriesT>(value));
    return *this;
  }
  template <typename EntriesT = PutEventsResultEntry>
  PutEventsResult& AddEntries(EntriesT&& value) {
    m_entriesHasBeenSet = true;
    m_entries.emplace_back(std::forward<EntriesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutEventsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  int m_failedEntryCount{0};

  Aws::Vector<PutEventsResultEntry> m_entries;

  Aws::String m_requestId;
  bool m_failedEntryCountHasBeenSet = false;
  bool m_entriesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EventBridge
}  // namespace Aws
