﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/vpc-lattice/VPCLattice_EXPORTS.h>
#include <aws/vpc-lattice/model/Target.h>
#include <aws/vpc-lattice/model/TargetFailure.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace VPCLattice {
namespace Model {
class RegisterTargetsResult {
 public:
  AWS_VPCLATTICE_API RegisterTargetsResult() = default;
  AWS_VPCLATTICE_API RegisterTargetsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_VPCLATTICE_API RegisterTargetsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The targets that were successfully registered.</p>
   */
  inline const Aws::Vector<Target>& GetSuccessful() const { return m_successful; }
  template <typename SuccessfulT = Aws::Vector<Target>>
  void SetSuccessful(SuccessfulT&& value) {
    m_successfulHasBeenSet = true;
    m_successful = std::forward<SuccessfulT>(value);
  }
  template <typename SuccessfulT = Aws::Vector<Target>>
  RegisterTargetsResult& WithSuccessful(SuccessfulT&& value) {
    SetSuccessful(std::forward<SuccessfulT>(value));
    return *this;
  }
  template <typename SuccessfulT = Target>
  RegisterTargetsResult& AddSuccessful(SuccessfulT&& value) {
    m_successfulHasBeenSet = true;
    m_successful.emplace_back(std::forward<SuccessfulT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The targets that were not registered.</p>
   */
  inline const Aws::Vector<TargetFailure>& GetUnsuccessful() const { return m_unsuccessful; }
  template <typename UnsuccessfulT = Aws::Vector<TargetFailure>>
  void SetUnsuccessful(UnsuccessfulT&& value) {
    m_unsuccessfulHasBeenSet = true;
    m_unsuccessful = std::forward<UnsuccessfulT>(value);
  }
  template <typename UnsuccessfulT = Aws::Vector<TargetFailure>>
  RegisterTargetsResult& WithUnsuccessful(UnsuccessfulT&& value) {
    SetUnsuccessful(std::forward<UnsuccessfulT>(value));
    return *this;
  }
  template <typename UnsuccessfulT = TargetFailure>
  RegisterTargetsResult& AddUnsuccessful(UnsuccessfulT&& value) {
    m_unsuccessfulHasBeenSet = true;
    m_unsuccessful.emplace_back(std::forward<UnsuccessfulT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  RegisterTargetsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Target> m_successful;

  Aws::Vector<TargetFailure> m_unsuccessful;

  Aws::String m_requestId;
  bool m_successfulHasBeenSet = false;
  bool m_unsuccessfulHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace VPCLattice
}  // namespace Aws
