﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>
#include <aws/pinpoint-sms-voice-v2/model/PhoneNumberInformation.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoiceV2 {
namespace Model {
class DescribePhoneNumbersResult {
 public:
  AWS_PINPOINTSMSVOICEV2_API DescribePhoneNumbersResult() = default;
  AWS_PINPOINTSMSVOICEV2_API DescribePhoneNumbersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINTSMSVOICEV2_API DescribePhoneNumbersResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of PhoneNumberInformation objects that contain the details for the
   * requested phone numbers.</p>
   */
  inline const Aws::Vector<PhoneNumberInformation>& GetPhoneNumbers() const { return m_phoneNumbers; }
  template <typename PhoneNumbersT = Aws::Vector<PhoneNumberInformation>>
  void SetPhoneNumbers(PhoneNumbersT&& value) {
    m_phoneNumbersHasBeenSet = true;
    m_phoneNumbers = std::forward<PhoneNumbersT>(value);
  }
  template <typename PhoneNumbersT = Aws::Vector<PhoneNumberInformation>>
  DescribePhoneNumbersResult& WithPhoneNumbers(PhoneNumbersT&& value) {
    SetPhoneNumbers(std::forward<PhoneNumbersT>(value));
    return *this;
  }
  template <typename PhoneNumbersT = PhoneNumberInformation>
  DescribePhoneNumbersResult& AddPhoneNumbers(PhoneNumbersT&& value) {
    m_phoneNumbersHasBeenSet = true;
    m_phoneNumbers.emplace_back(std::forward<PhoneNumbersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to be used for the next set of paginated results. If this field is
   * empty then there are no more results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribePhoneNumbersResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribePhoneNumbersResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<PhoneNumberInformation> m_phoneNumbers;
  bool m_phoneNumbersHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
