/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.InfoProcessor;

public final class BlobLengthProcessor
implements InfoProcessor<Long> {
    private static final byte[] BLOB_LENGTH_ITEMS = new byte[]{6, 1};

    @Override
    public Long process(byte[] infoResponse) throws SQLException {
        if (infoResponse.length == 0) {
            throw FbExceptionBuilder.forException(337248307).messageParameter("blob").toSQLException();
        }
        if (infoResponse[0] != 6) {
            throw new FbExceptionBuilder().exception(337248306).messageParameter("transaction", "isc_info_blob_total_length", 6, infoResponse[0]).toSQLException();
        }
        int dataLength = VaxEncoding.iscVaxInteger2(infoResponse, 1);
        return VaxEncoding.iscVaxLong(infoResponse, 3, dataLength);
    }

    public byte[] getBlobLengthItems() {
        return (byte[])BLOB_LENGTH_ITEMS.clone();
    }
}

