/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnection;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcPeeringConnectionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcPeeringConnectionsResponse> {
    private static final SdkField<List<VpcPeeringConnection>> VPC_PEERING_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcPeeringConnections").getter(DescribeVpcPeeringConnectionsResponse.getter(DescribeVpcPeeringConnectionsResponse::vpcPeeringConnections)).setter(DescribeVpcPeeringConnectionsResponse.setter(Builder::vpcPeeringConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionSet").unmarshallLocationName("vpcPeeringConnectionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcPeeringConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVpcPeeringConnectionsResponse.getter(DescribeVpcPeeringConnectionsResponse::nextToken)).setter(DescribeVpcPeeringConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_PEERING_CONNECTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVpcPeeringConnectionsResponse.memberNameToFieldInitializer();
    private final List<VpcPeeringConnection> vpcPeeringConnections;
    private final String nextToken;

    private DescribeVpcPeeringConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcPeeringConnections = builder.vpcPeeringConnections;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVpcPeeringConnections() {
        return this.vpcPeeringConnections != null && !(this.vpcPeeringConnections instanceof SdkAutoConstructList);
    }

    public final List<VpcPeeringConnection> vpcPeeringConnections() {
        return this.vpcPeeringConnections;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcPeeringConnections() ? this.vpcPeeringConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcPeeringConnectionsResponse)) {
            return false;
        }
        DescribeVpcPeeringConnectionsResponse other = (DescribeVpcPeeringConnectionsResponse)((Object)obj);
        return this.hasVpcPeeringConnections() == other.hasVpcPeeringConnections() && Objects.equals(this.vpcPeeringConnections(), other.vpcPeeringConnections()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcPeeringConnectionsResponse").add("VpcPeeringConnections", this.hasVpcPeeringConnections() ? this.vpcPeeringConnections() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcPeeringConnections": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnections()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcPeeringConnectionSet", VPC_PEERING_CONNECTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcPeeringConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeVpcPeeringConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VpcPeeringConnection> vpcPeeringConnections = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcPeeringConnectionsResponse model) {
            super(model);
            this.vpcPeeringConnections(model.vpcPeeringConnections);
            this.nextToken(model.nextToken);
        }

        public final List<VpcPeeringConnection.Builder> getVpcPeeringConnections() {
            List<VpcPeeringConnection.Builder> result = VpcPeeringConnectionListCopier.copyToBuilder(this.vpcPeeringConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcPeeringConnections(Collection<VpcPeeringConnection.BuilderImpl> vpcPeeringConnections) {
            this.vpcPeeringConnections = VpcPeeringConnectionListCopier.copyFromBuilder(vpcPeeringConnections);
        }

        @Override
        public final Builder vpcPeeringConnections(Collection<VpcPeeringConnection> vpcPeeringConnections) {
            this.vpcPeeringConnections = VpcPeeringConnectionListCopier.copy(vpcPeeringConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringConnections(VpcPeeringConnection ... vpcPeeringConnections) {
            this.vpcPeeringConnections(Arrays.asList(vpcPeeringConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringConnections(Consumer<VpcPeeringConnection.Builder> ... vpcPeeringConnections) {
            this.vpcPeeringConnections(Stream.of(vpcPeeringConnections).map(c -> (VpcPeeringConnection)((VpcPeeringConnection.Builder)VpcPeeringConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVpcPeeringConnectionsResponse build() {
            return new DescribeVpcPeeringConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcPeeringConnectionsResponse> {
        public Builder vpcPeeringConnections(Collection<VpcPeeringConnection> var1);

        public Builder vpcPeeringConnections(VpcPeeringConnection ... var1);

        public Builder vpcPeeringConnections(Consumer<VpcPeeringConnection.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

