/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.ad.caching.ADCacheProvider;
import org.opensearch.ad.caching.ADPriorityCache;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.ml.ADCheckpointDao;
import org.opensearch.ad.ml.ADColdStart;
import org.opensearch.ad.ml.ADModelManager;
import org.opensearch.ad.ml.ADRealTimeInferencer;
import org.opensearch.ad.ml.ThresholdingResult;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.ratelimit.ADCheckpointReadWorker;
import org.opensearch.ad.ratelimit.ADCheckpointWriteWorker;
import org.opensearch.ad.ratelimit.ADColdEntityWorker;
import org.opensearch.ad.ratelimit.ADColdStartWorker;
import org.opensearch.ad.ratelimit.ADSaveResultStrategy;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.EntityADResultAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.caching.CacheProvider;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.LimitExceededException;
import org.opensearch.timeseries.transport.EntityResultProcessor;
import org.opensearch.timeseries.transport.EntityResultRequest;
import org.opensearch.timeseries.util.ExceptionUtil;
import org.opensearch.transport.TransportService;

public class EntityADResultTransportAction
extends HandledTransportAction<EntityResultRequest, AcknowledgedResponse> {
    private static final Logger LOG = LogManager.getLogger(EntityADResultTransportAction.class);
    private CircuitBreakerService adCircuitBreakerService;
    private CacheProvider<ThresholdedRandomCutForest, ADPriorityCache> cache;
    private final NodeStateManager stateManager;
    private ThreadPool threadPool;
    private EntityResultProcessor<ThresholdedRandomCutForest, AnomalyResult, ThresholdingResult, ADIndex, ADIndexManagement, ADCheckpointDao, ADCheckpointWriteWorker, ADColdStart, ADModelManager, ADPriorityCache, ADSaveResultStrategy, ADTaskCacheManager, ADTaskType, ADTask, ADTaskManager, ADColdStartWorker, ADRealTimeInferencer, ADCheckpointReadWorker, ADColdEntityWorker> intervalDataProcessor;
    private final ADCacheProvider entityCache;
    private final ADCheckpointReadWorker checkpointReadQueue;
    private final ADColdEntityWorker coldEntityQueue;
    private final ADRealTimeInferencer inferencer;

    @Inject
    public EntityADResultTransportAction(ActionFilters actionFilters, TransportService transportService, CircuitBreakerService adCircuitBreakerService, ADCacheProvider entityCache, NodeStateManager stateManager, ADIndexManagement indexUtil, ADCheckpointReadWorker checkpointReadQueue, ADColdEntityWorker coldEntityQueue, ThreadPool threadPool, ADRealTimeInferencer inferencer) {
        super(EntityADResultAction.NAME, transportService, actionFilters, EntityResultRequest::new);
        this.adCircuitBreakerService = adCircuitBreakerService;
        this.cache = entityCache;
        this.stateManager = stateManager;
        this.threadPool = threadPool;
        this.entityCache = entityCache;
        this.checkpointReadQueue = checkpointReadQueue;
        this.coldEntityQueue = coldEntityQueue;
        this.intervalDataProcessor = null;
        this.inferencer = inferencer;
    }

    protected void doExecute(Task task, EntityResultRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (this.adCircuitBreakerService.isOpen().booleanValue()) {
            this.threadPool.executor("ad-threadpool").execute(() -> ((ADPriorityCache)this.cache.get()).releaseMemoryForOpenCircuitBreaker());
            listener.onFailure((Exception)new LimitExceededException(request.getConfigId(), "The total OpenSearch memory usage exceeds our threshold, opening the memory circuit.", false));
            return;
        }
        try {
            String detectorId = request.getConfigId();
            Optional<Exception> previousException = this.stateManager.fetchExceptionAndClear(detectorId);
            if (previousException.isPresent()) {
                EndRunException endRunException;
                Exception exception = previousException.get();
                LOG.error("Previous exception of {}: {}", (Object)detectorId, (Object)exception);
                if (exception instanceof EndRunException && (endRunException = (EndRunException)exception).isEndNow()) {
                    listener.onFailure(exception);
                    return;
                }
                listener = ExceptionUtil.wrapListener(listener, exception, detectorId);
            }
            this.intervalDataProcessor = new EntityResultProcessor(this.entityCache, this.checkpointReadQueue, this.coldEntityQueue, this.inferencer, this.threadPool, "ad-threadpool");
            this.stateManager.getConfig(detectorId, request.getAnalysisType(), true, this.intervalDataProcessor.onGetConfig(listener, detectorId, request, previousException, request.getAnalysisType()));
        }
        catch (Exception exception) {
            LOG.error("fail to get entity's anomaly grade", (Throwable)exception);
            listener.onFailure(exception);
        }
    }
}

