/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMUPublicId;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSAUnique
implements TPMUPublicId {
    private final byte[] n;

    public RSAUnique(@NotNull byte[] n) {
        this.n = n;
    }

    @NotNull
    public byte[] getN() {
        return ArrayUtil.clone(this.n);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RSAUnique rsaUnique = (RSAUnique)o;
        return Arrays.equals(this.n, rsaUnique.n);
    }

    public int hashCode() {
        return Arrays.hashCode(this.n);
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(2 + this.n.length);
        buffer.put(UnsignedNumberUtil.toBytes(this.getN().length));
        buffer.put(this.getN());
        return buffer.array();
    }
}

