/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.digest;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism.digest.DigestUtil;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;

public class PasswordDigestObtainer {
    private final CallbackHandler callbackHandler;
    private final ElytronMessages log;
    private final String credentialAlgorithm;
    private final MessageDigest messageDigest;
    private final Supplier<Provider[]> passwordFactoryProviders;
    private final String[] realms;
    private final boolean readOnlyRealmUsername;
    private final boolean skipRealmCallbacks;
    private String username;
    private String realm;
    private RealmChoiceCallback realmChoiceCallBack;
    private RealmCallback realmCallback;
    private NameCallback nameCallback;

    public PasswordDigestObtainer(CallbackHandler callbackHandler, String defaultUsername, String defaultRealm, ElytronMessages log, String credentialAlgorithm, MessageDigest messageDigest, Supplier<Provider[]> passwordFactoryProviders, String[] realms, boolean readOnlyRealmUsername, boolean skipRealmCallbacks) {
        this.callbackHandler = (CallbackHandler)Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler);
        this.username = defaultUsername;
        this.realm = defaultRealm;
        this.log = log;
        this.credentialAlgorithm = (String)Assert.checkNotNullParam((String)"credentialAlgorithm", (Object)credentialAlgorithm);
        this.messageDigest = (MessageDigest)Assert.checkNotNullParam((String)"messageDigest", (Object)messageDigest);
        this.passwordFactoryProviders = (Supplier)Assert.checkNotNullParam((String)"passwordFactoryProviders", passwordFactoryProviders);
        this.realms = realms;
        this.readOnlyRealmUsername = readOnlyRealmUsername;
        this.skipRealmCallbacks = skipRealmCallbacks;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealm() {
        return this.realm;
    }

    public byte[] handleUserRealmPasswordCallbacks() throws AuthenticationMechanismException {
        RealmChoiceCallback realmChoiceCallback = this.realmChoiceCallBack = this.skipRealmCallbacks || this.realms == null || this.realms.length <= 1 ? null : new RealmChoiceCallback("User realm: ", this.realms, 0, false);
        this.realmCallback = this.skipRealmCallbacks ? null : (this.realm != null ? new RealmCallback("User realm: ", this.realm) : new RealmCallback("User realm: "));
        this.nameCallback = this.username != null && !this.username.isEmpty() ? new NameCallback("User name: ", this.username) : new NameCallback("User name: ");
        byte[] digest = this.getPredigestedSaltedPassword();
        if (digest != null) {
            return digest;
        }
        digest = this.getSaltedPasswordFromTwoWay();
        if (digest != null) {
            return digest;
        }
        digest = this.getSaltedPasswordFromPasswordCallback();
        if (digest != null) {
            return digest;
        }
        throw this.log.mechCallbackHandlerDoesNotSupportCredentialAcquisition(null);
    }

    private byte[] getPredigestedSaltedPassword() throws AuthenticationMechanismException {
        if (this.realmChoiceCallBack != null) {
            try {
                this.callbackHandler.handle(new Callback[]{this.realmChoiceCallBack});
                int[] selected = this.realmChoiceCallBack.getSelectedIndexes();
                if (selected == null || selected.length == 0) {
                    throw this.log.mechNotChosenRealm();
                }
                this.realm = this.realms[selected[0]];
            }
            catch (UnsupportedCallbackException e) {
                this.realmChoiceCallBack = null;
            }
            catch (AuthenticationMechanismException e) {
                throw e;
            }
            catch (Throwable t) {
                throw this.log.mechCallbackHandlerFailedForUnknownReason(t);
            }
        }
        if (this.realmChoiceCallBack == null && this.realmCallback != null) {
            try {
                this.callbackHandler.handle(new Callback[]{this.realmCallback});
                if (this.realmCallback.getText() != null) {
                    this.realm = this.realmCallback.getText();
                }
            }
            catch (UnsupportedCallbackException e) {
                this.realmCallback = null;
            }
            catch (Throwable t) {
                throw this.log.mechCallbackHandlerFailedForUnknownReason(t);
            }
        }
        CredentialCallback credentialCallback = null;
        try {
            this.callbackHandler.handle(new Callback[]{this.nameCallback});
            if (!this.readOnlyRealmUsername) {
                this.username = this.nameCallback.getName();
                if (this.username == null) {
                    throw this.log.mechNotProvidedUserName();
                }
            }
            DigestPasswordAlgorithmSpec parameterSpec = this.username != null && this.realm != null ? new DigestPasswordAlgorithmSpec(this.username, this.realm) : null;
            credentialCallback = new CredentialCallback(PasswordCredential.class, this.credentialAlgorithm, (AlgorithmParameterSpec)parameterSpec);
            this.callbackHandler.handle(new Callback[]{credentialCallback});
            return (byte[])credentialCallback.applyToCredential(PasswordCredential.class, c -> (byte[])c.getPassword().castAndApply(DigestPassword.class, DigestPassword::getDigest));
        }
        catch (UnsupportedCallbackException e) {
            if (e.getCallback() == this.nameCallback) {
                throw this.log.mechCallbackHandlerDoesNotSupportUserName((Throwable)e);
            }
            if (credentialCallback == null || e.getCallback() != credentialCallback) {
                throw this.log.mechCallbackHandlerFailedForUnknownReason((Throwable)e);
            }
        }
        catch (AuthenticationMechanismException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.log.mechCallbackHandlerFailedForUnknownReason(t);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getSaltedPasswordFromTwoWay() throws AuthenticationMechanismException {
        char[] passwordChars;
        TwoWayPassword password;
        CredentialCallback credentialCallback;
        block33: {
            if (this.realmChoiceCallBack != null) {
                try {
                    this.callbackHandler.handle(new Callback[]{this.realmChoiceCallBack});
                    int[] selected = this.realmChoiceCallBack.getSelectedIndexes();
                    if (selected == null) throw this.log.mechNotChosenRealm();
                    if (selected.length == 0) {
                        throw this.log.mechNotChosenRealm();
                    }
                    this.realm = this.realms[selected[0]];
                }
                catch (UnsupportedCallbackException e) {
                    this.realmChoiceCallBack = null;
                }
                catch (Throwable t) {
                    throw this.log.mechCallbackHandlerFailedForUnknownReason(t);
                }
            }
            if (this.realmChoiceCallBack == null && this.realmCallback != null) {
                try {
                    this.callbackHandler.handle(new Callback[]{this.realmCallback});
                    if (this.realmCallback.getText() != null) {
                        this.realm = this.realmCallback.getText();
                    }
                }
                catch (UnsupportedCallbackException e) {
                    this.realmCallback = null;
                }
                catch (Throwable t) {
                    throw this.log.mechCallbackHandlerFailedForUnknownReason(t);
                }
            }
            credentialCallback = new CredentialCallback(PasswordCredential.class, "clear");
            password = null;
            passwordChars = null;
            this.callbackHandler.handle(new Callback[]{this.nameCallback, credentialCallback});
            if (!this.readOnlyRealmUsername) {
                this.username = this.nameCallback.getName();
                if (this.username == null) {
                    throw this.log.mechNotProvidedUserName();
                }
            }
            if ((password = (TwoWayPassword)credentialCallback.applyToCredential(PasswordCredential.class, c -> (TwoWayPassword)c.getPassword().castAs(TwoWayPassword.class))) != null) {
                passwordChars = DigestUtil.getTwoWayPasswordChars(password, this.passwordFactoryProviders, this.log);
                byte[] byArray = DigestUtil.userRealmPasswordDigest(this.messageDigest, this.username, this.realm, passwordChars);
                if (password != null) {
                    try {
                        password.destroy();
                    }
                    catch (DestroyFailedException e) {
                        this.log.credentialDestroyingFailed((Throwable)e);
                    }
                }
                if (passwordChars == null) return byArray;
                Arrays.fill(passwordChars, '\u0000');
                return byArray;
            }
            if (password == null) break block33;
            try {
                password.destroy();
            }
            catch (DestroyFailedException e) {
                this.log.credentialDestroyingFailed((Throwable)e);
            }
        }
        if (passwordChars == null) return null;
        Arrays.fill(passwordChars, '\u0000');
        return null;
        catch (UnsupportedCallbackException e) {
            if (e.getCallback() == this.nameCallback) {
                throw this.log.mechCallbackHandlerDoesNotSupportUserName((Throwable)e);
            }
            if (e.getCallback() == credentialCallback) return null;
            throw this.log.mechCallbackHandlerFailedForUnknownReason((Throwable)e);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (AuthenticationMechanismException e2) {
                throw e2;
                catch (Throwable t) {
                    throw this.log.mechCallbackHandlerFailedForUnknownReason(t);
                }
            }
        }
        finally {
            if (password != null) {
                try {
                    password.destroy();
                }
                catch (DestroyFailedException e) {
                    this.log.credentialDestroyingFailed((Throwable)e);
                }
            }
            if (passwordChars != null) {
                Arrays.fill(passwordChars, '\u0000');
            }
        }
    }

    private byte[] getSaltedPasswordFromPasswordCallback() throws AuthenticationMechanismException {
        PasswordCallback passwordCallback = new PasswordCallback("User password: ", false);
        if (this.realmChoiceCallBack != null) {
            try {
                this.callbackHandler.handle(new Callback[]{this.realmChoiceCallBack, this.nameCallback, passwordCallback});
                int[] selected = this.realmChoiceCallBack.getSelectedIndexes();
                if (selected == null || selected.length == 0) {
                    throw this.log.mechNotChosenRealm();
                }
                this.realm = this.realms[selected[0]];
            }
            catch (UnsupportedCallbackException e) {
                if (e.getCallback() == this.realmChoiceCallBack) {
                    this.realmChoiceCallBack = null;
                }
                if (e.getCallback() == this.nameCallback) {
                    throw this.log.mechCallbackHandlerDoesNotSupportUserName((Throwable)e);
                }
                if (e.getCallback() == passwordCallback) {
                    throw this.log.mechCallbackHandlerDoesNotSupportCredentialAcquisition((Throwable)e);
                }
                throw this.log.mechCallbackHandlerFailedForUnknownReason((Throwable)e);
            }
            catch (AuthenticationMechanismException e) {
                throw e;
            }
            catch (Throwable t) {
                throw this.log.mechCallbackHandlerFailedForUnknownReason(t);
            }
        }
        if (this.realmChoiceCallBack == null && this.realmCallback != null) {
            try {
                this.callbackHandler.handle(new Callback[]{this.realmCallback, this.nameCallback, passwordCallback});
                if (this.realmCallback.getText() != null) {
                    this.realm = this.realmCallback.getText();
                }
            }
            catch (UnsupportedCallbackException e) {
                if (e.getCallback() == this.realmCallback) {
                    this.realmCallback = null;
                }
                if (e.getCallback() == this.nameCallback) {
                    throw this.log.mechCallbackHandlerDoesNotSupportUserName((Throwable)e);
                }
                if (e.getCallback() == passwordCallback) {
                    throw this.log.mechCallbackHandlerDoesNotSupportCredentialAcquisition((Throwable)e);
                }
                throw this.log.mechCallbackHandlerFailedForUnknownReason((Throwable)e);
            }
            catch (Throwable t) {
                throw this.log.mechCallbackHandlerFailedForUnknownReason(t);
            }
        }
        if (this.realmChoiceCallBack == null && this.realmCallback == null) {
            try {
                this.callbackHandler.handle(new Callback[]{this.nameCallback, passwordCallback});
            }
            catch (UnsupportedCallbackException e) {
                if (e.getCallback() == this.nameCallback) {
                    throw this.log.mechCallbackHandlerDoesNotSupportUserName((Throwable)e);
                }
                if (e.getCallback() == passwordCallback) {
                    throw this.log.mechCallbackHandlerDoesNotSupportCredentialAcquisition((Throwable)e);
                }
                throw this.log.mechCallbackHandlerFailedForUnknownReason((Throwable)e);
            }
            catch (Throwable t) {
                throw this.log.mechCallbackHandlerFailedForUnknownReason(t);
            }
        }
        char[] passwordChars = passwordCallback.getPassword();
        passwordCallback.clearPassword();
        if (!this.readOnlyRealmUsername) {
            this.username = this.nameCallback.getName();
            if (this.username == null) {
                throw this.log.mechNotProvidedUserName();
            }
        }
        if (passwordChars == null) {
            throw this.log.mechNoPasswordGiven();
        }
        byte[] digest_urp = DigestUtil.userRealmPasswordDigest(this.messageDigest, this.username, this.realm, passwordChars);
        Arrays.fill(passwordChars, '\u0000');
        return digest_urp;
    }
}

