/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import java.io.IOException;
import org.keycloak.connections.jpa.support.EntityManagers;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.utils.KeycloakSessionUtil;

public abstract class ExportImportSessionTask {
    public void runTask(KeycloakSessionFactory factory) {
        this.runTask(factory, Mode.NORMAL);
    }

    public void runTask(KeycloakSessionFactory factory, Mode mode) {
        boolean useExistingSession = ExportImportConfig.isSingleTransaction();
        KeycloakSession existing = KeycloakSessionUtil.getKeycloakSession();
        if (useExistingSession && existing != null && existing.getTransactionManager().isActive()) {
            this.run(mode, existing);
        } else {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, session -> this.run(mode, session));
        }
    }

    private void run(Mode mode, KeycloakSession session) {
        Runnable task = () -> {
            try {
                this.runExportImportTask(session);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error during export/import: " + ioe.getMessage(), ioe);
            }
        };
        if (mode == Mode.BATCHED) {
            EntityManagers.runInBatch((KeycloakSession)session, (Runnable)task, (boolean)true);
        } else {
            task.run();
        }
    }

    protected abstract void runExportImportTask(KeycloakSession var1) throws IOException;

    public static enum Mode {
        BATCHED,
        NORMAL;

    }
}

